/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.impl.AbstractPMDProcessor;
import net.sourceforge.pmd.lang.impl.AbstractPMDProcessorTest;
import net.sourceforge.pmd.lang.impl.MultiThreadProcessor;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class MultiThreadProcessorTest
extends AbstractPMDProcessorTest {
    MultiThreadProcessorTest() {
    }

    @Override
    protected int getThreads() {
        return 2;
    }

    @Override
    protected Class<? extends AbstractPMDProcessor> getExpectedImplementation() {
        return MultiThreadProcessor.class;
    }

    private PmdAnalysis createPmdAnalysis(String ruleset) {
        PmdAnalysis pmd = this.createPmdAnalysis();
        pmd.addRuleSet(pmd.newRuleSetLoader().loadFromResource(ruleset));
        return pmd;
    }

    @Test
    void errorsShouldBeThrown() {
        Error error = (Error)Assertions.assertThrows(Error.class, () -> {
            try (PmdAnalysis pmd = this.createPmdAnalysis();){
                pmd.addRuleSet(RuleSet.forSingleRule((Rule)new AbstractPMDProcessorTest.RuleThatThrowsError()));
                pmd.performAnalysis();
            }
        });
        Assertions.assertEquals((Object)"test error", (Object)error.getMessage());
        Assertions.assertTrue((this.reportListener.files.get() >= 1 ? 1 : 0) != 0);
        ((PmdReporter)Mockito.verify((Object)this.reporter)).error((String)Mockito.eq((Object)"Unknown error occurred while executing a PmdRunnable: {0}"), new Object[]{Mockito.eq((Object)"java.lang.Error: test error"), Mockito.any(Error.class)});
    }

    @Test
    void testRulesThreadSafety() throws Exception {
        try (PmdAnalysis pmd = this.createPmdAnalysis("rulesets/MultiThreadProcessorTest/basic.xml");){
            pmd.performAnalysis();
        }
        Assertions.assertEquals((int)2, (int)NotThreadSafeRule.count.get(), (String)"Test rule has not been executed");
        Assertions.assertEquals((int)1, (int)this.reportListener.violations.get(), (String)"Missing violation");
    }

    public static class DysfunctionalRule
    extends AbstractRule {
        public static final String DYSFUNCTIONAL_RULE_REASON = "dysfunctional rule is dysfunctional";

        public void apply(Node target, RuleContext ctx) {
        }

        public String dysfunctionReason() {
            return DYSFUNCTIONAL_RULE_REASON;
        }
    }

    public static class NotThreadSafeRule
    extends AbstractRule {
        public static AtomicInteger count = new AtomicInteger(0);
        private boolean hasViolation;

        public void apply(Node target, RuleContext ctx) {
            count.incrementAndGet();
            if (target.getTextDocument().getFileId().getOriginalPath().contains("violation")) {
                this.hasViolation = true;
            } else {
                this.letTheOtherThreadRun(10);
                this.hasViolation = false;
            }
            this.letTheOtherThreadRun(100);
            if (this.hasViolation) {
                ctx.addViolation(target);
            }
        }

        private void letTheOtherThreadRun(int millis) {
            try {
                Thread.yield();
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

