/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.lang.impl.AbstractPMDProcessor;
import net.sourceforge.pmd.lang.impl.AbstractPMDProcessorTest;
import net.sourceforge.pmd.lang.impl.MonoThreadProcessor;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class MonoThreadProcessorTest
extends AbstractPMDProcessorTest {
    MonoThreadProcessorTest() {
    }

    @Override
    protected int getThreads() {
        return 0;
    }

    @Override
    protected Class<? extends AbstractPMDProcessor> getExpectedImplementation() {
        return MonoThreadProcessor.class;
    }

    @Test
    void errorsShouldBeThrown() {
        try (PmdAnalysis pmd = this.createPmdAnalysis();){
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)new AbstractPMDProcessorTest.RuleThatThrowsError()));
            Error exception = (Error)Assertions.assertThrows(Error.class, () -> ((PmdAnalysis)pmd).performAnalysis());
            Assertions.assertEquals((Object)"test error", (Object)exception.getMessage());
        }
        Assertions.assertEquals((int)1, (int)this.reportListener.files.get());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.reporter});
    }
}

