/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextFileContent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class TextFileContentTest {
    private static final String LINESEP_SENTINEL = ":fallback:";

    TextFileContentTest() {
    }

    @ParameterizedTest
    @EnumSource
    void testMixedDelimiters(TextContentOrigin origin) throws IOException {
        TextFileContent content = origin.normalize("a\r\nb\n\rc");
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a\nb\n\nc"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)LINESEP_SENTINEL, (Object)content.getLineTerminator());
    }

    @ParameterizedTest
    @EnumSource
    void testFormFeedIsNotNewline(TextContentOrigin origin) throws IOException {
        TextFileContent content = origin.normalize("a\f\nb\nc");
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a\f\nb\nc"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)"\n", (Object)content.getLineTerminator());
    }

    @Test
    void testNormTextPreservation() {
        Chars input = Chars.wrap((CharSequence)"a\nb\nc");
        TextFileContent content = TextFileContent.fromCharSeq((CharSequence)input);
        Assertions.assertSame((Object)input, (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)"\n", (Object)content.getLineTerminator());
    }

    @ParameterizedTest
    @EnumSource
    void testBomElimination(TextContentOrigin origin) throws IOException {
        TextFileContent content = origin.normalize("\ufeffabc");
        Chars normalizedText = content.getNormalizedText();
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"abc"), (Object)normalizedText);
        Assertions.assertTrue((boolean)normalizedText.isFullString(), (String)"should be full string");
        Assertions.assertSame((Object)normalizedText.toString(), (Object)normalizedText.toString());
    }

    @ParameterizedTest
    @EnumSource
    void testNoExplicitLineMarkers(TextContentOrigin origin) throws IOException {
        TextFileContent content = origin.normalize("a");
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)LINESEP_SENTINEL, (Object)content.getLineTerminator());
    }

    @ParameterizedTest
    @EnumSource
    void testEmptyFile(TextContentOrigin origin) throws IOException {
        TextFileContent content = origin.normalize("");
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)""), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)LINESEP_SENTINEL, (Object)content.getLineTerminator());
    }

    @Test
    void testCrlfSplitOnBuffer() throws IOException {
        StringReader reader = new StringReader("a\r\nb");
        TextFileContent content = TextFileContent.normalizingRead((Reader)reader, (int)2, (String)System.lineSeparator());
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a\nb"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)"\r\n", (Object)content.getLineTerminator());
    }

    @Test
    void testCrSplitOnBufferFp() throws IOException {
        StringReader reader = new StringReader("a\rb\n");
        TextFileContent content = TextFileContent.normalizingRead((Reader)reader, (int)2, (String)LINESEP_SENTINEL);
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a\nb\n"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)LINESEP_SENTINEL, (Object)content.getLineTerminator());
    }

    @ParameterizedTest
    @EnumSource
    void testCrCr(TextContentOrigin origin) throws IOException {
        TextFileContent content = origin.normalize("a\r\rb");
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a\n\nb"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)"\r", (Object)content.getLineTerminator());
    }

    @ParameterizedTest
    @EnumSource
    void testCrIsEol(TextContentOrigin origin) throws IOException {
        TextFileContent content = origin.normalize("a\rb\rdede");
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a\nb\ndede"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)"\r", (Object)content.getLineTerminator());
    }

    @ParameterizedTest
    @EnumSource
    void testLfAtStartOfFile(TextContentOrigin origin) throws IOException {
        TextFileContent content = origin.normalize("\nohio");
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"\nohio"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)"\n", (Object)content.getLineTerminator());
    }

    @Test
    void testCrCrSplitBuffer() throws IOException {
        StringReader reader = new StringReader("a\r\r");
        TextFileContent content = TextFileContent.normalizingRead((Reader)reader, (int)2, (String)LINESEP_SENTINEL);
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a\n\n"), (Object)content.getNormalizedText());
        Assertions.assertEquals((Object)"\r", (Object)content.getLineTerminator());
    }

    static enum TextContentOrigin {
        INPUT_STREAM{

            @Override
            TextFileContent normalize(String text) throws IOException {
                TextFileContent content;
                Charset charset = StandardCharsets.UTF_8;
                byte[] input = text.getBytes(charset);
                try (ByteArrayInputStream bar = new ByteArrayInputStream(input);){
                    content = TextFileContent.fromInputStream((InputStream)bar, (Charset)charset, (String)TextFileContentTest.LINESEP_SENTINEL);
                }
                return content;
            }
        }
        ,
        READER{

            @Override
            TextFileContent normalize(String input) throws IOException {
                return TextFileContent.normalizingRead((Reader)new StringReader(input), (int)4096, (String)TextFileContentTest.LINESEP_SENTINEL);
            }
        }
        ,
        STRING{

            @Override
            TextFileContent normalize(String input) throws IOException {
                return TextFileContent.normalizeCharSeq((CharSequence)input, (String)TextFileContentTest.LINESEP_SENTINEL);
            }
        };


        abstract TextFileContent normalize(String var1) throws IOException;
    }
}

