/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import net.sourceforge.pmd.lang.document.SourceCodePositioner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SourceCodePositionerTest {
    SourceCodePositionerTest() {
    }

    @Test
    void testLineNumberFromOffset() {
        String source = "abcd\ndefghi\n\rjklmn\ropq";
        SourceCodePositioner positioner = SourceCodePositioner.create((CharSequence)"abcd\ndefghi\n\rjklmn\ropq");
        int offset = "abcd\ndefghi\n\rjklmn\ropq".indexOf(97);
        Assertions.assertEquals((int)1, (int)positioner.lineNumberFromOffset(offset));
        Assertions.assertEquals((int)1, (int)positioner.columnFromOffset(1, offset));
        offset = "abcd\ndefghi\n\rjklmn\ropq".indexOf(98);
        Assertions.assertEquals((int)1, (int)positioner.lineNumberFromOffset(offset));
        Assertions.assertEquals((int)2, (int)positioner.columnFromOffset(1, offset));
        offset = "abcd\ndefghi\n\rjklmn\ropq".indexOf(101);
        Assertions.assertEquals((int)2, (int)positioner.lineNumberFromOffset(offset));
        Assertions.assertEquals((int)2, (int)positioner.columnFromOffset(2, offset));
        offset = "abcd\ndefghi\n\rjklmn\ropq".indexOf(113);
        Assertions.assertEquals((int)3, (int)positioner.lineNumberFromOffset(offset));
        Assertions.assertEquals((int)10, (int)positioner.columnFromOffset(3, offset));
        offset = "abcd\ndefghi\n\rjklmn\ropq".length();
        Assertions.assertEquals((int)3, (int)positioner.lineNumberFromOffset(offset));
        Assertions.assertEquals((int)11, (int)positioner.columnFromOffset(3, offset));
        offset = "abcd\ndefghi\n\rjklmn\ropq".length() + 1;
        Assertions.assertEquals((int)-1, (int)positioner.lineNumberFromOffset(offset));
        Assertions.assertEquals((int)-1, (int)positioner.columnFromOffset(3, offset));
    }

    @Test
    void testOffsetFromLineColumn() {
        String source = "abcd\ndefghi\r\njklmn\nopq";
        SourceCodePositioner positioner = SourceCodePositioner.create((CharSequence)"abcd\ndefghi\r\njklmn\nopq");
        Assertions.assertEquals((int)0, (int)positioner.offsetFromLineColumn(1, 1));
        Assertions.assertEquals((int)2, (int)positioner.offsetFromLineColumn(1, 3));
        Assertions.assertEquals((int)"abcd\n".length(), (int)positioner.offsetFromLineColumn(2, 1));
        Assertions.assertEquals((int)"abcd\nd".length(), (int)positioner.offsetFromLineColumn(2, 2));
        Assertions.assertEquals((int)"abcd\nde".length(), (int)positioner.offsetFromLineColumn(2, 3));
        Assertions.assertEquals((int)"abcd\ndef".length(), (int)positioner.offsetFromLineColumn(2, 4));
        Assertions.assertEquals((int)"abcd\ndefghi\r\n".length(), (int)positioner.offsetFromLineColumn(3, 1));
        Assertions.assertEquals((int)"abcd\ndefghi\r\njklmn\nopq".length(), (int)positioner.offsetFromLineColumn(4, 4));
        Assertions.assertEquals((int)-1, (int)positioner.offsetFromLineColumn(4, 5));
        Assertions.assertEquals((int)"abcd\ndefghi\r\njklmn\nopq".length(), (int)positioner.offsetFromLineColumn(5, 1));
        Assertions.assertEquals((int)-1, (int)positioner.offsetFromLineColumn(5, 2));
    }

    @Test
    void testWrongOffsets() {
        String source = "abcd\ndefghi\r\njklmn\nopq";
        SourceCodePositioner positioner = SourceCodePositioner.create((CharSequence)"abcd\ndefghi\r\njklmn\nopq");
        Assertions.assertEquals((int)0, (int)positioner.offsetFromLineColumn(1, 1));
        Assertions.assertEquals((int)1, (int)positioner.offsetFromLineColumn(1, 2));
        Assertions.assertEquals((int)2, (int)positioner.offsetFromLineColumn(1, 3));
        Assertions.assertEquals((int)3, (int)positioner.offsetFromLineColumn(1, 4));
        Assertions.assertEquals((int)4, (int)positioner.offsetFromLineColumn(1, 5));
        Assertions.assertEquals((int)5, (int)positioner.offsetFromLineColumn(1, 6));
        Assertions.assertEquals((int)-1, (int)positioner.offsetFromLineColumn(1, 7));
    }

    @Test
    void testEmptyDocument() {
        SourceCodePositioner positioner = SourceCodePositioner.create((CharSequence)"");
        Assertions.assertEquals((int)0, (int)positioner.offsetFromLineColumn(1, 1));
        Assertions.assertEquals((int)-1, (int)positioner.offsetFromLineColumn(1, 2));
        Assertions.assertEquals((int)1, (int)positioner.lineNumberFromOffset(0));
        Assertions.assertEquals((int)-1, (int)positioner.lineNumberFromOffset(1));
        Assertions.assertEquals((int)1, (int)positioner.columnFromOffset(1, 0));
        Assertions.assertEquals((int)-1, (int)positioner.columnFromOffset(1, 1));
    }

    @Test
    void testDocumentStartingWithNl() {
        SourceCodePositioner positioner = SourceCodePositioner.create((CharSequence)"\n");
        Assertions.assertEquals((int)0, (int)positioner.offsetFromLineColumn(1, 1));
        Assertions.assertEquals((int)1, (int)positioner.offsetFromLineColumn(1, 2));
        Assertions.assertEquals((int)-1, (int)positioner.offsetFromLineColumn(1, 3));
        Assertions.assertEquals((int)1, (int)positioner.lineNumberFromOffset(0));
        Assertions.assertEquals((int)2, (int)positioner.lineNumberFromOffset(1));
        Assertions.assertEquals((int)-1, (int)positioner.lineNumberFromOffset(2));
    }

    @Test
    void lineToOffsetMappingWithLineFeedShouldSucceed() {
        String code = "public static int main(String[] args) {\nint var;\n}";
        SourceCodePositioner positioner = SourceCodePositioner.create((CharSequence)"public static int main(String[] args) {\nint var;\n}");
        Assertions.assertArrayEquals((int[])new int[]{0, 40, 49, 50}, (int[])positioner.getLineOffsets());
    }

    @Test
    void lineToOffsetMappingWithCarriageReturnFeedLineFeedShouldSucceed() {
        String code = "public static int main(String[] args) {\r\nint var;\r\n}";
        SourceCodePositioner positioner = SourceCodePositioner.create((CharSequence)"public static int main(String[] args) {\r\nint var;\r\n}");
        Assertions.assertArrayEquals((int[])new int[]{0, 41, 51, 52}, (int[])positioner.getLineOffsets());
    }

    @Test
    void lineToOffsetMappingWithMixedLineSeparatorsShouldSucceed() {
        String code = "public static int main(String[] args) {\r\nint var;\n}";
        SourceCodePositioner positioner = SourceCodePositioner.create((CharSequence)"public static int main(String[] args) {\r\nint var;\n}");
        Assertions.assertArrayEquals((int[])new int[]{0, 41, 50, 51}, (int[])positioner.getLineOffsets());
    }
}

