/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileLocationTest {
    public static final FileId FNAME = FileId.fromPathLikeString((String)"fname");

    FileLocationTest() {
    }

    @Test
    void testSimple() {
        FileLocation loc = FileLocation.range((FileId)FNAME, (TextRange2d)TextRange2d.range2d((int)1, (int)1, (int)1, (int)2));
        Assertions.assertEquals((Object)FNAME, (Object)loc.getFileId());
        Assertions.assertEquals((int)1, (int)loc.getStartLine());
        Assertions.assertEquals((int)1, (int)loc.getStartColumn());
        Assertions.assertEquals((int)1, (int)loc.getEndLine());
        Assertions.assertEquals((int)2, (int)loc.getEndColumn());
    }

    @Test
    void testToRange() {
        TextRange2d range2d = TextRange2d.range2d((int)1, (int)1, (int)1, (int)2);
        FileLocation loc = FileLocation.range((FileId)FNAME, (TextRange2d)range2d);
        Assertions.assertEquals((Object)range2d, (Object)loc.toRange2d());
    }

    @Test
    void testToString() {
        FileLocation loc = FileLocation.range((FileId)FNAME, (TextRange2d)TextRange2d.range2d((int)1, (int)1, (int)1, (int)2));
        Assertions.assertEquals((Object)"line 1, column 1", (Object)loc.startPosToString());
        Assertions.assertEquals((Object)"fname:1:1", (Object)loc.startPosToStringWithFile());
        MatcherAssert.assertThat((Object)loc.toString(), (Matcher)CoreMatchers.containsString((String)"!debug only!"));
    }
}

