/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.document.FileCollectorTest;
import net.sourceforge.pmd.lang.document.TextFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileCollectorZipTest {
    private static final String ZIP_PATH = "src/test/resources/net/sourceforge/pmd/lang/document/filecollectorziptest/zipWithSources.zip";
    private final Path zipPath = Paths.get("src/test/resources/net/sourceforge/pmd/lang/document/filecollectorziptest/zipWithSources.zip", new String[0]);

    FileCollectorZipTest() {
    }

    @Test
    void testZipFile() {
        PMDConfiguration conf = new PMDConfiguration();
        conf.addInputPath(this.zipPath);
        String reportPath = this.zipPath.toString();
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)conf);){
            List files = pmd.files().getCollectedFiles();
            MatcherAssert.assertThat((Object)files, (Matcher)Matchers.hasSize((int)3));
            FileCollectorTest.assertHasName((TextFile)files.get(0), reportPath + "!/otherSrc/somefile.dummy", pmd);
            FileCollectorTest.assertHasName((TextFile)files.get(1), reportPath + "!/src/somefile.dummy", pmd);
            FileCollectorTest.assertHasName((TextFile)files.get(2), reportPath + "!/src/somefile1.dummy", pmd);
        }
    }

    @Test
    void testZipFileIds() throws IOException {
        PMDConfiguration conf = new PMDConfiguration();
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)conf);){
            pmd.files().addZipFileWithContent(this.zipPath);
            List files = pmd.files().getCollectedFiles();
            MatcherAssert.assertThat((Object)files, (Matcher)Matchers.hasSize((int)3));
            MatcherAssert.assertThat((Object)((TextFile)files.get(0)).getFileId().getUriString(), (Matcher)Matchers.equalTo((Object)("jar:" + this.zipPath.toUri() + "!/otherSrc/somefile.dummy")));
        }
    }

    @Test
    void testZipFileRelativizeWith() {
        PMDConfiguration conf = new PMDConfiguration();
        conf.addInputPath(this.zipPath);
        conf.addRelativizeRoot(Paths.get("src/test/resources", new String[0]));
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)conf);){
            List files = pmd.files().getCollectedFiles();
            MatcherAssert.assertThat((Object)files, (Matcher)Matchers.hasSize((int)3));
            String baseZipPath = IOUtil.normalizePath((String)"net/sourceforge/pmd/lang/document/filecollectorziptest/zipWithSources.zip");
            FileCollectorTest.assertHasName((TextFile)files.get(0), baseZipPath + "!/otherSrc/somefile.dummy", pmd);
            FileCollectorTest.assertHasName((TextFile)files.get(1), baseZipPath + "!/src/somefile.dummy", pmd);
            FileCollectorTest.assertHasName((TextFile)files.get(2), baseZipPath + "!/src/somefile1.dummy", pmd);
        }
    }

    @Test
    void testZipFileRelativizeWithRoot() {
        PMDConfiguration conf = new PMDConfiguration();
        conf.addInputPath(this.zipPath);
        conf.addRelativizeRoot(this.zipPath.toAbsolutePath().getRoot());
        String reportPath = this.zipPath.toAbsolutePath().toString();
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)conf);){
            List files = pmd.files().getCollectedFiles();
            MatcherAssert.assertThat((Object)files, (Matcher)Matchers.hasSize((int)3));
            Assertions.assertEquals((Object)"/otherSrc/somefile.dummy", (Object)((TextFile)files.get(0)).getFileId().getAbsolutePath());
            URI zipUri = this.zipPath.toUri();
            Assertions.assertEquals((Object)("jar:" + zipUri + "!/otherSrc/somefile.dummy"), (Object)((TextFile)files.get(0)).getFileId().getUriString());
            FileCollectorTest.assertHasName((TextFile)files.get(0), reportPath + "!/otherSrc/somefile.dummy", pmd);
            FileCollectorTest.assertHasName((TextFile)files.get(1), reportPath + "!/src/somefile.dummy", pmd);
            FileCollectorTest.assertHasName((TextFile)files.get(2), reportPath + "!/src/somefile1.dummy", pmd);
        }
    }
}

