/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.IteratorUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CharsTest {
    CharsTest() {
    }

    @Test
    void wrapStringRoundTrip() {
        String s = "ooo";
        Assertions.assertSame((Object)s, (Object)Chars.wrap((CharSequence)s).toString());
    }

    @Test
    void wrapCharsRoundTrip() {
        Chars s = Chars.wrap((CharSequence)"ooo");
        Assertions.assertSame((Object)s, (Object)Chars.wrap((CharSequence)s));
    }

    @Test
    void appendChars() {
        StringBuilder sb = new StringBuilder();
        Chars bc = Chars.wrap((CharSequence)"abcd").slice(1, 2);
        Assertions.assertEquals((Object)"bc", (Object)bc.toString());
        bc.appendChars(sb);
        Assertions.assertEquals((Object)"bc", (Object)sb.toString());
    }

    @Test
    void appendCharsWithOffsets() {
        StringBuilder sb = new StringBuilder();
        Chars bc = Chars.wrap((CharSequence)"abcd").slice(1, 2);
        Assertions.assertEquals((Object)"bc", (Object)bc.toString());
        bc.appendChars(sb, 0, 1);
        Assertions.assertEquals((Object)"b", (Object)sb.toString());
    }

    @Test
    void toStringBuilder() {
        Chars bc = Chars.wrap((CharSequence)"abcd").slice(1, 2);
        Assertions.assertEquals((Object)"bc", (Object)bc.toString());
        Assertions.assertEquals((Object)"bc", (Object)bc.toStringBuilder().toString());
    }

    @Test
    void write() throws IOException {
        StringWriter writer = new StringWriter();
        Chars bc = Chars.wrap((CharSequence)"abcd").slice(1, 2);
        Assertions.assertEquals((Object)"bc", (Object)bc.toString());
        bc.write((Writer)writer, 0, 1);
        Assertions.assertEquals((Object)"b", (Object)writer.toString());
        writer = new StringWriter();
        bc.writeFully((Writer)writer);
        Assertions.assertEquals((Object)"bc", (Object)writer.toString());
    }

    @Test
    void getChars() {
        char[] arr = new char[4];
        Chars bc = Chars.wrap((CharSequence)"abcd").slice(1, 2);
        bc.getChars(0, arr, 1, 2);
        Assertions.assertArrayEquals((char[])arr, (char[])new char[]{'\u0000', 'b', 'c', '\u0000'});
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> bc.getChars(2, arr, 0, 1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> bc.getChars(-1, arr, 0, 1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> bc.getChars(0, arr, 0, 3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> bc.getChars(0, arr, 4, 3));
        Assertions.assertThrows(NullPointerException.class, () -> bc.getChars(0, null, 0, 0));
    }

    @Test
    void indexOf() {
        Chars bc = Chars.wrap((CharSequence)"aaaaabcdb").slice(5, 2);
        Assertions.assertEquals((int)0, (int)bc.indexOf(98, 0));
        Assertions.assertEquals((int)1, (int)bc.indexOf(99, 0));
        Assertions.assertEquals((int)-1, (int)bc.indexOf(98, 1));
        Assertions.assertEquals((int)-1, (int)bc.indexOf(100, 0));
        Assertions.assertEquals((int)-1, (int)bc.indexOf(120, 0));
        Assertions.assertEquals((int)-1, (int)bc.indexOf(97, -1));
    }

    @Test
    void indexOfString() {
        Chars bc = Chars.wrap((CharSequence)"aaaaabcdb").slice(5, 2);
        Assertions.assertEquals((int)0, (int)bc.indexOf("b", 0));
        Assertions.assertEquals((int)0, (int)bc.indexOf("bc", 0));
        Assertions.assertEquals((int)1, (int)bc.indexOf("c", 0));
        Assertions.assertEquals((int)-1, (int)bc.indexOf("b", 1));
        Assertions.assertEquals((int)-1, (int)bc.indexOf("bc", 1));
        Assertions.assertEquals((int)-1, (int)bc.indexOf("d", 0));
        Assertions.assertEquals((int)-1, (int)bc.indexOf("bcd", 0));
        Assertions.assertEquals((int)-1, (int)bc.indexOf("x", 0));
        Assertions.assertEquals((int)-1, (int)bc.indexOf("ab", -1));
        bc = Chars.wrap((CharSequence)"aaaaabcdbxdb").slice(5, 5);
        Assertions.assertEquals((int)3, (int)bc.indexOf("bx", 0));
        bc = Chars.wrap((CharSequence)"aaaaabcbxdb").slice(5, 5);
        Assertions.assertEquals((int)2, (int)bc.indexOf("bx", 0));
    }

    @Test
    void lastIndexOf() {
        Chars bc = Chars.wrap((CharSequence)"aaaaabcdb").slice(5, 2);
        Assertions.assertEquals((int)0, (int)bc.lastIndexOf(98, 0));
        Assertions.assertEquals((int)0, (int)bc.lastIndexOf(98, 1));
        Assertions.assertEquals((int)1, (int)bc.lastIndexOf(99, 1));
        Assertions.assertEquals((int)-1, (int)bc.lastIndexOf(99, 0));
        Assertions.assertEquals((int)-1, (int)bc.lastIndexOf(100, 0));
        Assertions.assertEquals((int)-1, (int)bc.lastIndexOf(120, 0));
        Assertions.assertEquals((int)-1, (int)bc.lastIndexOf(97, -1));
        Assertions.assertEquals((int)-1, (int)bc.lastIndexOf(97, 0));
        Assertions.assertEquals((int)-1, (int)bc.lastIndexOf(97, 1));
    }

    @Test
    void startsWith() {
        Chars bc = Chars.wrap((CharSequence)"abcdb").slice(1, 2);
        Assertions.assertTrue((boolean)bc.startsWith("bc"));
        Assertions.assertTrue((boolean)bc.startsWith("bc", 0));
        Assertions.assertTrue((boolean)bc.startsWith("c", 1));
        Assertions.assertTrue((boolean)bc.startsWith('c', 1));
        Assertions.assertTrue((boolean)bc.startsWith("", 1));
        Assertions.assertTrue((boolean)bc.startsWith("", 0));
        Assertions.assertFalse((boolean)bc.startsWith("c", 0));
        Assertions.assertFalse((boolean)bc.startsWith('c', 0));
        Assertions.assertFalse((boolean)bc.startsWith("bcd", 0));
        Assertions.assertFalse((boolean)bc.startsWith("xcd", 0));
        Assertions.assertFalse((boolean)bc.startsWith("b", -1));
        Assertions.assertFalse((boolean)bc.startsWith('b', -1));
        Assertions.assertFalse((boolean)bc.startsWith("", -1));
        Assertions.assertFalse((boolean)bc.startsWith("", 5));
    }

    @Test
    void removeSuffix() {
        Chars bc = Chars.wrap((CharSequence)"abcdb").slice(1, 2);
        Assertions.assertEquals((Object)"bc", (Object)bc.toString());
        Assertions.assertEquals((Object)"b", (Object)bc.removeSuffix("c").toString());
        Assertions.assertEquals((Object)"", (Object)bc.removeSuffix("bc").toString());
        bc = Chars.wrap((CharSequence)"aaaaaaa").slice(2, 3);
        Assertions.assertEquals((Object)"", (Object)bc.removeSuffix("aaa").toString());
        Assertions.assertEquals((Object)"aaa", (Object)bc.removeSuffix("aaaa").toString());
    }

    @Test
    void removePrefix() {
        Chars bc = Chars.wrap((CharSequence)"abcdb").slice(1, 2);
        Assertions.assertEquals((Object)"bc", (Object)bc.toString());
        Assertions.assertEquals((Object)"bc", (Object)bc.removePrefix("c").toString());
        Assertions.assertEquals((Object)"", (Object)bc.removePrefix("bc").toString());
        Assertions.assertEquals((Object)"c", (Object)bc.removePrefix("b").toString());
        bc = Chars.wrap((CharSequence)"aaaaaaa").slice(2, 3);
        Assertions.assertEquals((Object)"aaa", (Object)bc.toString());
        Assertions.assertEquals((Object)"", (Object)bc.removePrefix("aaa").toString());
        Assertions.assertEquals((Object)"aaa", (Object)bc.removePrefix("aaaa").toString());
    }

    @Test
    void trimNoop() {
        Chars bc = Chars.wrap((CharSequence)"abcdb").slice(1, 2);
        Assertions.assertEquals((Object)"bc", (Object)bc.toString());
        Assertions.assertEquals((Object)"bc", (Object)bc.trimStart().toString());
        Assertions.assertEquals((Object)"bc", (Object)bc.trimEnd().toString());
        Assertions.assertEquals((Object)"bc", (Object)bc.trim().toString());
    }

    @Test
    void trimStartAndEnd() {
        Chars bc = Chars.wrap((CharSequence)"a   bc db").slice(1, 6);
        Assertions.assertEquals((Object)"   bc ", (Object)bc.toString());
        Assertions.assertEquals((Object)"bc ", (Object)bc.trimStart().toString());
        Assertions.assertEquals((Object)"   bc", (Object)bc.trimEnd().toString());
        Assertions.assertEquals((Object)"bc", (Object)bc.trim().toString());
    }

    @Test
    void charAt() {
        Chars bc = Chars.wrap((CharSequence)"a   bc db").slice(1, 6);
        Assertions.assertEquals((char)' ', (char)bc.charAt(0));
        Assertions.assertEquals((char)'b', (char)bc.charAt(3));
        Assertions.assertEquals((char)'c', (char)bc.charAt(4));
        Assertions.assertEquals((char)' ', (char)bc.charAt(5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> bc.charAt(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> bc.charAt(7));
    }

    @Test
    void linesTest() {
        Chars bc = Chars.wrap((CharSequence)"a \n  \r\nbc db").slice(1, 9);
        List lines = CollectionUtil.map((Iterable)bc.lines(), Chars::toString);
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)" ", (Object[])new String[]{"  ", "bc "}), (Object)lines);
    }

    @Test
    void linesTest2() {
        Chars bc = Chars.wrap((CharSequence)"aa\n");
        List lines = CollectionUtil.map((Iterable)bc.lines(), Chars::toString);
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"aa", (Object[])new String[0]), (Object)lines);
    }

    @Test
    void linesStreamTest() {
        Chars bc = Chars.wrap((CharSequence)"aa\nb\rded\r\nlff");
        List lines = bc.lineStream().map(Chars::toString).collect(Collectors.toList());
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"aa", (Object[])new String[]{"b", "ded", "lff"}), lines);
    }

    @Test
    void linesTest3WithCr() {
        Chars bc = Chars.wrap((CharSequence)"aa\rb");
        List lines = CollectionUtil.map((Iterable)bc.lines(), Chars::toString);
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"aa", (Object[])new String[]{"b"}), (Object)lines);
    }

    @Test
    void testEqualsHashCode() {
        Chars chars = Chars.wrap((CharSequence)"a_a_b_c_s").slice(2, 5);
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"a_b_c"), (Object)chars);
        Assertions.assertNotEquals((Object)"a_b_c", (Object)chars);
        Assertions.assertEquals((int)Chars.wrap((CharSequence)"a_b_c").hashCode(), (int)chars.hashCode());
        Assertions.assertEquals((Object)chars, (Object)chars);
        Assertions.assertEquals((int)"a_b_c".hashCode(), (int)Chars.wrap((CharSequence)"a_b_c").hashCode());
        Assertions.assertEquals((int)"a_b_c".hashCode(), (int)chars.hashCode());
    }

    @Test
    void testContentEquals() {
        Chars chars = Chars.wrap((CharSequence)"a_a_b_c_s").slice(2, 5);
        Assertions.assertTrue((boolean)chars.contentEquals((CharSequence)"a_b_c"));
        Assertions.assertTrue((boolean)chars.contentEquals((CharSequence)Chars.wrap((CharSequence)"a_b_c")));
        Assertions.assertFalse((boolean)chars.contentEquals((CharSequence)"a_b_c_--"));
        Assertions.assertFalse((boolean)chars.contentEquals((CharSequence)Chars.wrap((CharSequence)"a_b_c_")));
        Assertions.assertFalse((boolean)chars.contentEquals((CharSequence)Chars.wrap((CharSequence)"a_b-c")));
        Assertions.assertTrue((boolean)chars.contentEquals((CharSequence)Chars.wrap((CharSequence)"A_B_C"), true));
    }

    @Test
    void testSplits() {
        Chars chars = Chars.wrap((CharSequence)"a_a_b_c_s").slice(2, 5);
        Assertions.assertEquals((Object)"a_b_c", (Object)chars.toString());
        this.testSplits(chars, "_");
        this.testSplits(chars, "a");
        this.testSplits(chars, "b");
        this.testSplits(chars, "c");
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"", (Object[])new String[]{"_b_c"}), this.listSplits(chars, "a"));
        chars = chars.subSequence(1, 5);
        Assertions.assertEquals((Object)"_b_c", (Object)chars.toString());
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"", (Object[])new String[]{"b", "c"}), this.listSplits(chars, "_"));
        this.testSplits(Chars.wrap((CharSequence)"abc"), "");
        this.testSplits(Chars.wrap((CharSequence)""), "");
    }

    private List<String> listSplits(Chars chars, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Iterator splits = chars.splits(pattern).iterator();
        return IteratorUtil.toList((Iterator)IteratorUtil.map(splits, Chars::toString));
    }

    private void testSplits(Chars chars, String regex) {
        List<String> splitList = this.listSplits(chars, regex);
        List<String> expected = Arrays.asList(chars.toString().split(regex));
        Assertions.assertEquals(expected, splitList, (String)"Split should behave like String#split");
    }

    @Test
    void testSlice() {
        Chars chars = Chars.wrap((CharSequence)"a_a_b_c_s").slice(2, 5);
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"_b_"), (Object)chars.slice(1, 3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> chars.slice(0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> chars.slice(0, 6));
    }

    @Test
    void testSubsequence() {
        Chars chars = Chars.wrap((CharSequence)"a_a_b_c_s").slice(2, 5);
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"_b"), (Object)chars.subSequence(1, 3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> chars.slice(0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> chars.slice(0, 6));
    }

    @Test
    void testSubstring() {
        Chars chars = Chars.wrap((CharSequence)"a_a_b_c_s").slice(2, 5);
        Assertions.assertEquals((Object)"_b", (Object)chars.substring(1, 3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> chars.substring(0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> chars.substring(0, 6));
    }

    @Test
    void testTrimBlankLines() {
        this.assertTrimBlankLinesEquals(" \n \n abc \n \n de \n \n ", " abc \n \n de ");
        this.assertTrimBlankLinesEquals("", "");
    }

    private void assertTrimBlankLinesEquals(String input, String expected) {
        Chars actual = Chars.wrap((CharSequence)input).trimBlankLines();
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)expected), (Object)actual);
    }

    @Test
    void testReaderSingleChars() throws IOException {
        Chars bc = Chars.wrap((CharSequence)"a \n  \r\nbc db").slice(1, 9);
        try (Reader reader = bc.newReader();){
            Assertions.assertEquals((int)32, (int)reader.read());
            Assertions.assertEquals((int)10, (int)reader.read());
            Assertions.assertEquals((int)32, (int)reader.read());
            Assertions.assertEquals((int)32, (int)reader.read());
            Assertions.assertEquals((int)13, (int)reader.read());
            Assertions.assertEquals((int)10, (int)reader.read());
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertEquals((int)99, (int)reader.read());
            Assertions.assertEquals((int)32, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    void testReaderBuffer() throws IOException {
        Chars bc = Chars.wrap((CharSequence)"a \n  \r\nbc db").slice(1, 9);
        char[] cbuf = new char[4];
        try (Reader reader = bc.newReader();){
            Assertions.assertEquals((int)4, (int)reader.read(cbuf));
            CharsTest.assertCharBufEquals(" \n  ", cbuf);
            Assertions.assertEquals((int)4, (int)reader.read(cbuf));
            CharsTest.assertCharBufEquals("\r\nbc", cbuf);
            Assertions.assertEquals((int)1, (int)reader.read(cbuf));
            CharsTest.assertCharBufEquals(" \nbc", cbuf);
            Assertions.assertEquals((int)-1, (int)reader.read(cbuf));
        }
    }

    @Test
    void testReaderSlicedBuffer() throws IOException {
        Chars bc = Chars.wrap((CharSequence)"a \n  \r\nbc db").slice(1, 9);
        char[] cbuf = new char[6];
        try (Reader reader = bc.newReader();){
            Assertions.assertEquals((int)4, (int)reader.read(cbuf, 1, 4));
            CharsTest.assertCharBufEquals("\u0000 \n  \u0000", cbuf);
            Assertions.assertEquals((int)5, (int)reader.read(cbuf, 1, 5));
            CharsTest.assertCharBufEquals("\u0000\r\nbc ", cbuf);
            Assertions.assertEquals((int)-1, (int)reader.read(cbuf));
            Assertions.assertEquals((int)-1, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read(cbuf, 1, 4));
        }
    }

    @Test
    void testReadClosed() throws IOException {
        Chars bc = Chars.wrap((CharSequence)"a \n  \r\nbc db").slice(1, 9);
        Reader reader = bc.newReader();
        reader.close();
        Assertions.assertThrows(IOException.class, reader::read);
    }

    @Test
    void testReaderMark() throws IOException {
        Chars bc = Chars.wrap((CharSequence)"abcdefghijklmnop").slice(1, 9);
        try (Reader reader = bc.newReader();){
            Assertions.assertTrue((boolean)reader.markSupported(), (String)"markSupported");
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertEquals((int)99, (int)reader.read());
            Assertions.assertEquals((int)100, (int)reader.read());
            Assertions.assertEquals((int)101, (int)reader.read());
            reader.mark(10);
            Assertions.assertEquals((int)102, (int)reader.read());
            Assertions.assertEquals((int)103, (int)reader.read());
            reader.reset();
            Assertions.assertEquals((int)102, (int)reader.read());
            Assertions.assertEquals((int)103, (int)reader.read());
            reader.reset();
            Assertions.assertEquals((int)102, (int)reader.read());
            Assertions.assertEquals((int)103, (int)reader.read());
        }
    }

    @Test
    void testReaderMissingMark() throws IOException {
        Chars bc = Chars.wrap((CharSequence)"abcdefghijklmnop").slice(1, 9);
        try (Reader reader = bc.newReader();){
            Assertions.assertTrue((boolean)reader.markSupported(), (String)"markSupported");
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertThrows(IOException.class, reader::reset);
        }
    }

    @Test
    void testReaderSkip() throws IOException {
        Chars bc = Chars.wrap((CharSequence)"abcdefghijklmnop").slice(1, 9);
        try (Reader reader = bc.newReader();){
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertEquals((int)99, (int)reader.read());
            Assertions.assertEquals((int)100, (int)reader.read());
            Assertions.assertEquals((int)101, (int)reader.read());
            reader.mark(10);
            Assertions.assertEquals((long)2L, (long)reader.skip(2L));
            Assertions.assertEquals((int)104, (int)reader.read());
            Assertions.assertEquals((int)105, (int)reader.read());
            reader.reset();
            Assertions.assertEquals((int)102, (int)reader.read());
            Assertions.assertEquals((int)103, (int)reader.read());
        }
    }

    @Test
    void testReaderInvalidParams() throws IOException {
        Chars bc = Chars.wrap((CharSequence)"abcdefghijklmnop").slice(1, 9);
        char[] cbuf = new char[4];
        try (Reader reader = bc.newReader();){
            Assertions.assertTrue((boolean)reader.markSupported(), (String)"markSupported");
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertThrows(NullPointerException.class, () -> reader.read(null, 0, 0));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(cbuf, -1, 0));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(cbuf, 1, 12));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(cbuf, 1, -1));
        }
    }

    private static void assertCharBufEquals(String expected, char[] cbuf) {
        String actual = new String(cbuf);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

