/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.DummyTreeUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class NodeStreamBlanketTest<T extends Node> {
    private static final List<Node> ASTS = Arrays.asList(new Node[]{DummyTreeUtil.tree(() -> DummyTreeUtil.root(DummyTreeUtil.node(DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.nodeB(DummyTreeUtil.node(DummyTreeUtil.nodeB(new DummyNode[0]))), DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.nodeB(new DummyNode[0])), DummyTreeUtil.node(new DummyNode[0]))), DummyTreeUtil.tree(() -> DummyTreeUtil.root(DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.nodeB(DummyTreeUtil.node(new DummyNode[0])), DummyTreeUtil.node(new DummyNode[0])))});

    NodeStreamBlanketTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"allNodeStreamVariants"})
    void testToListConsistency(NodeStream<T> stream) {
        List toList = stream.toList();
        List collected = (List)stream.collect(Collectors.toList());
        List fromStream = stream.toStream().collect(Collectors.toList());
        List cached = stream.cached().toList();
        Assertions.assertEquals((Object)toList, (Object)collected);
        Assertions.assertEquals((Object)toList, fromStream);
        Assertions.assertEquals((Object)toList, (Object)cached);
    }

    @ParameterizedTest
    @MethodSource(value={"allNodeStreamVariants"})
    void testToListSize(NodeStream<T> stream) {
        List toList = stream.toList();
        Assertions.assertEquals((int)toList.size(), (int)stream.count());
    }

    @ParameterizedTest
    @MethodSource(value={"nodeStreamVariantsNonEmpty"})
    void testLast(NodeStream<T> stream) {
        NodeStreamBlanketTest.assertImplication(stream, NodeStreamBlanketTest.prop("nonEmpty", NodeStream::nonEmpty), NodeStreamBlanketTest.prop("last() == toList().last()", it -> it.last() == it.toList().get(it.count() - 1)));
    }

    @ParameterizedTest
    @MethodSource(value={"nodeStreamVariantsNonEmpty"})
    void testFirst(NodeStream<T> stream) {
        NodeStreamBlanketTest.assertImplication(stream, NodeStreamBlanketTest.prop("nonEmpty", NodeStream::nonEmpty), NodeStreamBlanketTest.prop("first() == toList().get(0)", it -> it.first() == it.toList().get(0)));
    }

    @ParameterizedTest
    @MethodSource(value={"nodeStreamVariantsNonEmpty"})
    void testDrop(NodeStream<T> stream) {
        NodeStreamBlanketTest.assertImplication(stream, NodeStreamBlanketTest.prop("nonEmpty", NodeStream::nonEmpty), NodeStreamBlanketTest.prop("drop(0) == this", it -> it.drop(0) == it), NodeStreamBlanketTest.prop("drop(1).count() == count() - 1", it -> it.drop(1).count() == it.count() - 1), NodeStreamBlanketTest.prop("drop(1).toList() == toList().tail()", it -> it.drop(1).toList().equals(NodeStreamBlanketTest.tail(it.toList()))));
    }

    @ParameterizedTest
    @MethodSource(value={"nodeStreamVariantsNonEmpty"})
    void testDropLast(NodeStream<T> stream) {
        NodeStreamBlanketTest.assertImplication(stream, NodeStreamBlanketTest.prop("nonEmpty", NodeStream::nonEmpty), NodeStreamBlanketTest.prop("dropLast(0) == this", it -> it.dropLast(0) == it), NodeStreamBlanketTest.prop("dropLast(1).count() == count() - 1", it -> it.dropLast(1).count() == it.count() - 1), NodeStreamBlanketTest.prop("dropLast(1).toList() == toList().init()", it -> it.dropLast(1).toList().equals(NodeStreamBlanketTest.init(it.toList()))));
    }

    @ParameterizedTest
    @MethodSource(value={"nodeStreamVariantsMoreThanOne"})
    void testDropMoreThan1(NodeStream<T> stream) {
        NodeStreamBlanketTest.assertImplication(stream, NodeStreamBlanketTest.prop("count() > 1", it -> it.count() > 1), NodeStreamBlanketTest.prop("drop(2).toList() == toList().tail().tail()", it -> it.drop(2).toList().equals(NodeStreamBlanketTest.tail(NodeStreamBlanketTest.tail(it.toList())))), NodeStreamBlanketTest.prop("drop(1).drop(1) == drop(2)", it -> it.drop(1).drop(1).toList().equals(it.drop(2).toList())));
    }

    @ParameterizedTest
    @MethodSource(value={"nodeStreamVariantsNonEmpty"})
    void testTake(NodeStream<T> stream) {
        NodeStreamBlanketTest.assertImplication(stream, NodeStreamBlanketTest.prop("nonEmpty", NodeStream::nonEmpty), NodeStreamBlanketTest.prop("it.take(0).count() == 0", it -> it.take(0).count() == 0), NodeStreamBlanketTest.prop("it.take(1).count() == 1", it -> it.take(1).count() == 1), NodeStreamBlanketTest.prop("it.take(it.count()).count() == it.count()", it -> it.take(it.count()).count() == it.count()));
    }

    @ParameterizedTest
    @MethodSource(value={"allNodeStreamVariants"})
    void testGet(NodeStream<T> stream) {
        for (int i = 0; i < 100; ++i) {
            Assertions.assertSame((Object)stream.get(i), (Object)stream.drop(i).first(), (String)"stream.get(i) == stream.drop(i).first()");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"allNodeStreamVariants"})
    void testGetNegative(NodeStream<T> stream) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> stream.get(-1));
    }

    @ParameterizedTest
    @MethodSource(value={"allNodeStreamVariants"})
    void testDropNegative(NodeStream<T> stream) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> stream.drop(-1));
    }

    @ParameterizedTest
    @MethodSource(value={"allNodeStreamVariants"})
    void testTakeNegative(NodeStream<T> stream) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> stream.take(-1));
    }

    @ParameterizedTest
    @MethodSource(value={"allNodeStreamVariants"})
    void testEmpty(NodeStream<T> stream) {
        NodeStreamBlanketTest.assertEquivalence(stream, NodeStreamBlanketTest.prop("isEmpty", NodeStream::isEmpty), NodeStreamBlanketTest.prop("!nonEmpty", it -> !it.nonEmpty()), NodeStreamBlanketTest.prop("last() == null", it -> it.last() == null), NodeStreamBlanketTest.prop("first() == null", it -> it.first() == null), NodeStreamBlanketTest.prop("first(_ -> true) == null", it -> it.first(i -> true) == null), NodeStreamBlanketTest.prop("first(Node.class) == null", it -> it.first(Node.class) == null), NodeStreamBlanketTest.prop("count() == 0", it -> it.count() == 0), NodeStreamBlanketTest.prop("any(_) == false", it -> !it.any(i -> true)), NodeStreamBlanketTest.prop("all(_) == true", it -> it.all(i -> false)), NodeStreamBlanketTest.prop("none(_) == true", it -> it.none(i -> true)));
    }

    static Collection<NodeStream<?>> nodeStreamVariantsNonEmpty() {
        return NodeStreamBlanketTest.allNodeStreamVariants().stream().filter(NodeStream::nonEmpty).collect(Collectors.toList());
    }

    static Collection<NodeStream<?>> nodeStreamVariantsMoreThanOne() {
        return NodeStreamBlanketTest.allNodeStreamVariants().stream().filter(n -> n.count() > 1).collect(Collectors.toList());
    }

    static Collection<NodeStream<?>> allNodeStreamVariants() {
        return ASTS.stream().flatMap(root -> Stream.of(root.asStream(), root.children().first().asStream(), NodeStream.empty())).flatMap(stream -> Stream.of(stream, stream.drop(1), stream.take(2), stream.filter(n -> !n.getImage().isEmpty()), stream.firstChild(DummyNode.DummyNodeTypeB.class), stream.children(DummyNode.DummyNodeTypeB.class), stream.descendants(DummyNode.DummyNodeTypeB.class), stream.ancestors(DummyNode.DummyNodeTypeB.class), stream.descendants(), stream.ancestors(), stream.ancestorsOrSelf(), stream.followingSiblings(), stream.precedingSiblings(), stream.descendantsOrSelf(), stream.children(), stream.children().filter(c -> c.getImage().equals("0")), stream.children(DummyNode.class))).flatMap(stream -> Stream.of(stream, stream.filterIs(DummyNode.class), stream.take(1), stream.drop(1), stream.filter(n -> !n.getImage().isEmpty()), stream.cached())).collect(Collectors.toCollection(ArrayList::new));
    }

    @SafeVarargs
    private static <T> void assertEquivalence(T input, Prop<? super T> ... properties) {
        for (Prop<T> prop : properties) {
            for (Prop<T> prop2 : properties) {
                boolean p1 = prop.test(input);
                Assertions.assertEquals((Object)p1, (Object)prop2.test(input), (String)("Expected (" + prop.description + ") === (" + prop2.description + "), but the LHS was " + p1 + " and the RHS was " + !p1));
            }
        }
    }

    @SafeVarargs
    private static <T> void assertImplication(T input, Prop<? super T> precond, Prop<? super T> ... properties) {
        Assumptions.assumeTrue((boolean)precond.test(input));
        for (Prop<T> prop : properties) {
            Assertions.assertTrue((boolean)prop.test(input), (String)("Expected (" + precond.description + ") to entail (" + prop.description + "), but the latter was false"));
        }
    }

    static <T> Prop<T> prop(String desc, Predicate<? super T> pred) {
        return new Prop<T>(pred, desc);
    }

    static <T> List<T> tail(List<T> ts) {
        return ts.subList(1, ts.size());
    }

    static <T> List<T> init(List<T> ts) {
        return ts.subList(0, ts.size() - 1);
    }

    static class Prop<T> {
        final Predicate<? super T> property;
        final String description;

        Prop(Predicate<? super T> property, String description) {
            this.property = property;
            this.description = description;
        }

        boolean test(T t) {
            return this.property.test(t);
        }
    }
}

