/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl;

import java.util.List;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.DummyTreeUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class AbstractNodeTest {
    private static final int NUM_CHILDREN = 3;
    private static final int NUM_GRAND_CHILDREN = 3;
    private DummyNode.DummyRootNode rootNode;

    AbstractNodeTest() {
    }

    static Integer[] childrenIndexes() {
        return AbstractNodeTest.getIntRange(3);
    }

    static Integer[] grandChildrenIndexes() {
        return AbstractNodeTest.getIntRange(3);
    }

    private static Integer[] getIntRange(int exclusiveLimit) {
        Integer[] childIndexes = new Integer[exclusiveLimit];
        for (int i = 0; i < exclusiveLimit; ++i) {
            childIndexes[i] = i;
        }
        return childIndexes;
    }

    static Object childrenAndGrandChildrenIndexes() {
        Integer[] childrenIndexes = AbstractNodeTest.childrenIndexes();
        Integer[] grandChildrenIndexes = AbstractNodeTest.grandChildrenIndexes();
        Object[] indexes = new Object[childrenIndexes.length * grandChildrenIndexes.length];
        int i = 0;
        Integer[] integerArray = childrenIndexes;
        int n = integerArray.length;
        for (int j = 0; j < n; ++j) {
            int childIndex = integerArray[j];
            Integer[] integerArray2 = grandChildrenIndexes;
            int n2 = integerArray2.length;
            for (int k = 0; k < n2; ++k) {
                int grandChildIndex = integerArray2[k];
                indexes[i++] = new Integer[]{childIndex, grandChildIndex};
            }
        }
        return indexes;
    }

    @BeforeEach
    void setUpSampleNodeTree() {
        this.rootNode = DummyTreeUtil.tree(() -> {
            DummyNode.DummyRootNode root = DummyTreeUtil.root(new DummyNode[0]);
            for (int i = 0; i < 3; ++i) {
                DummyNode child = DummyTreeUtil.node(new DummyNode[0]);
                for (int j = 0; j < 3; ++j) {
                    child.addChild(DummyTreeUtil.node(new DummyNode[0]), j);
                }
                root.addChild(child, i);
            }
            return root;
        });
    }

    @ParameterizedTest
    @MethodSource(value={"childrenIndexes"})
    void testRemoveChildOfRootNode(int childIndex) {
        DummyNode child = (DummyNode)this.rootNode.getChild(childIndex);
        List grandChildren = child.children().toList();
        child.remove();
        Assertions.assertEquals((int)2, (int)this.rootNode.getNumChildren());
        Assertions.assertNull((Object)child.getParent());
        Assertions.assertEquals((int)3, (int)child.getNumChildren());
        for (Node grandChild : grandChildren) {
            Assertions.assertEquals((Object)((Object)child), (Object)grandChild.getParent());
        }
    }

    @Test
    void testPrevNextSiblings() {
        DummyNode.DummyRootNode root = DummyTreeUtil.tree(() -> DummyTreeUtil.root(DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.node(new DummyNode[0])));
        Assertions.assertNull((Object)root.getNextSibling());
        Assertions.assertNull((Object)root.getPreviousSibling());
        DummyNode c0 = (DummyNode)root.getChild(0);
        DummyNode c1 = (DummyNode)root.getChild(1);
        Assertions.assertSame((Object)((Object)c0), (Object)c1.getPreviousSibling());
        Assertions.assertSame((Object)((Object)c1), (Object)c0.getNextSibling());
        Assertions.assertNull((Object)c1.getNextSibling());
        Assertions.assertNull((Object)c0.getPreviousSibling());
    }

    @Test
    void testRemoveRootNode() {
        List children = this.rootNode.children().toList();
        this.rootNode.remove();
        Assertions.assertEquals((int)3, (int)this.rootNode.getNumChildren());
        Assertions.assertNull((Object)this.rootNode.getParent());
        for (Node aChild : children) {
            Assertions.assertEquals((Object)((Object)this.rootNode), (Object)aChild.getParent());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"childrenAndGrandChildrenIndexes"})
    void testRemoveGrandChildNode(int childIndex, int grandChildIndex) {
        DummyNode child = (DummyNode)this.rootNode.getChild(childIndex);
        DummyNode grandChild = (DummyNode)child.getChild(grandChildIndex);
        grandChild.remove();
        Assertions.assertEquals((int)2, (int)child.getNumChildren());
        Assertions.assertEquals((int)0, (int)grandChild.getNumChildren());
        Assertions.assertNull((Object)grandChild.getParent());
    }

    @ParameterizedTest
    @MethodSource(value={"childrenIndexes"})
    void testRemoveRootNodeChildAtIndex(int childIndex) {
        List originalChildren = this.rootNode.children().toList();
        this.rootNode.removeChildAtIndex(childIndex);
        Assertions.assertEquals((int)2, (int)this.rootNode.getNumChildren());
        int j = 0;
        for (int i = 0; i < this.rootNode.getNumChildren(); ++i) {
            if (j == childIndex) {
                ++j;
            }
            Assertions.assertEquals(originalChildren.get(j), (Object)this.rootNode.getChild(i));
            Assertions.assertEquals((int)i, (int)((DummyNode)this.rootNode.getChild(i)).getIndexInParent());
            ++j;
        }
    }

    @Test
    void testRemoveChildAtIndexWithInvalidIndex() {
        try {
            this.rootNode.removeChildAtIndex(-1);
            this.rootNode.removeChildAtIndex(this.rootNode.getNumChildren());
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception was expected.");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"grandChildrenIndexes"})
    void testRemoveChildAtIndexOnNodeWithNoChildren(int grandChildIndex) {
        DummyNode grandChild = (DummyNode)((DummyNode)this.rootNode.getChild(grandChildIndex)).getChild(grandChildIndex);
        grandChild.removeChildAtIndex(0);
        Assertions.assertEquals((int)0, (int)grandChild.getNumChildren());
    }
}

