/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.slf4j.helpers.NOPLogger;

class SemanticErrorReporterTest {
    PmdReporter mockReporter;
    Logger mockLogger;
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();

    SemanticErrorReporterTest() {
    }

    @BeforeEach
    void setup() {
        this.mockReporter = (PmdReporter)Mockito.mock(PmdReporter.class);
        Mockito.when((Object)this.mockReporter.isLoggable(Level.ERROR)).thenReturn((Object)true);
        this.mockLogger = (Logger)Mockito.spy(NOPLogger.class);
    }

    @Test
    void testErrorLogging() {
        SemanticErrorReporter reporter = SemanticErrorReporter.reportToLogger((PmdReporter)this.mockReporter);
        RootNode node = this.parseMockNode();
        Assertions.assertNull((Object)reporter.getFirstError());
        String message = "an error occurred";
        reporter.error((Node)node, message, new Object[0]);
        ((PmdReporter)Mockito.verify((Object)this.mockReporter)).log((Level)Mockito.eq((Object)Level.ERROR), Mockito.contains((String)message), new Object[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
        Assertions.assertNotNull((Object)reporter.getFirstError());
    }

    @Test
    void testEscaping() {
        SemanticErrorReporter reporter = SemanticErrorReporter.reportToLogger((PmdReporter)this.mockReporter);
        RootNode node = this.parseMockNode();
        String message = "an apostrophe '' ";
        reporter.error((Node)node, message, new Object[0]);
        ((PmdReporter)Mockito.verify((Object)this.mockReporter)).log((Level)Mockito.eq((Object)Level.ERROR), Mockito.contains((String)"an apostrophe ''"), new Object[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    private RootNode parseMockNode() {
        return this.helper.parse("(mock (node))", "dummy/file.txt");
    }
}

