/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.CommentNode;
import net.sourceforge.pmd.lang.rule.xpath.TextNode;

public class DummyNode
extends AbstractNode<DummyNode, DummyNode> {
    private final boolean findBoundary;
    private String xpathName;
    private String image;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private TextRegion region = TextRegion.caretAt((int)0);

    public DummyNode(String xpathName) {
        this(false, xpathName);
    }

    public DummyNode() {
        this(false);
    }

    public DummyNode(boolean findBoundary) {
        this(findBoundary, "dummyNode");
    }

    public DummyNode(boolean findBoundary, String xpathName) {
        this.findBoundary = findBoundary;
        this.xpathName = xpathName;
        Iterator iter = super.getXPathAttributesIterator();
        while (iter.hasNext()) {
            this.attributes.add((Attribute)iter.next());
        }
    }

    public void addChild(DummyNode child, int index) {
        super.addChild((AbstractNode)child, index);
    }

    public void setParent(DummyNode node) {
        super.setParent((AbstractNode)node);
    }

    public void publicSetChildren(DummyNode ... children) {
        assert (this.getNumChildren() == 0);
        for (int i = children.length - 1; i >= 0; --i) {
            this.addChild(children[i], i);
        }
    }

    public TextRegion getTextRegion() {
        return this.region;
    }

    public void setRegion(TextRegion region) {
        this.region = region;
    }

    public void setImage(String image) {
        this.image = image;
        if (image.startsWith("#")) {
            this.xpathName = image;
        }
    }

    public String getImage() {
        return this.image;
    }

    public String toString() {
        return this.getXPathNodeName() + "[@Image=" + this.getImage() + "]";
    }

    public String getXPathNodeName() {
        return this.xpathName;
    }

    public boolean isFindBoundary() {
        return this.findBoundary;
    }

    public void setXPathAttribute(String name, String value) {
        this.attributes.add(new Attribute((Node)this, name, value));
    }

    public void clearXPathAttributes() {
        this.attributes.clear();
    }

    public Iterator<Attribute> getXPathAttributesIterator() {
        return this.attributes.iterator();
    }

    public static class DummyCommentNode
    extends DummyNode
    implements CommentNode {
        public String getData() {
            return this.getImage();
        }

        @Override
        public String getXPathNodeName() {
            return super.getXPathNodeName();
        }
    }

    public static class DummyTextNode
    extends DummyNode
    implements TextNode {
        public String getText() {
            return this.getImage();
        }

        @Override
        public String getXPathNodeName() {
            return super.getXPathNodeName();
        }
    }

    public static class DummyNodeTypeB
    extends DummyNode {
        public DummyNodeTypeB() {
            super("dummyNodeB");
        }
    }

    public static class DummyRootNode
    extends DummyNode
    implements RootNode,
    GenericNode<DummyNode> {
        private static final LanguageProcessor STATIC_PROCESSOR = DummyLanguageModule.getInstance().createProcessor(DummyLanguageModule.getInstance().newPropertyBundle());
        private AstInfo<DummyRootNode> astInfo;

        public DummyRootNode() {
            TextDocument document = TextDocument.readOnlyString((CharSequence)"dummy text", (FileId)FileId.UNKNOWN, (LanguageVersion)DummyLanguageModule.getInstance().getDefaultVersion());
            this.astInfo = new AstInfo(new Parser.ParserTask(document, SemanticErrorReporter.noop(), LanguageProcessorRegistry.singleton((LanguageProcessor)STATIC_PROCESSOR)), (RootNode)this);
        }

        public DummyRootNode withTaskInfo(Parser.ParserTask task) {
            this.astInfo = new AstInfo(task, (RootNode)this);
            return this;
        }

        public DummyRootNode withNoPmdComments(Map<Integer, String> suppressMap) {
            this.astInfo = this.astInfo.withSuppressMap(suppressMap);
            return this;
        }

        public AstInfo<DummyRootNode> getAstInfo() {
            return Objects.requireNonNull(this.astInfo, "no ast info");
        }

        @Override
        public String getXPathNodeName() {
            return "dummyRootNode";
        }
    }
}

