/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.List;
import net.sourceforge.pmd.lang.ast.DummyNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BoundaryTraversalTest {
    private DummyNode rootNode;

    BoundaryTraversalTest() {
    }

    private DummyNode newDummyNode(boolean boundary) {
        return new DummyNode(boundary);
    }

    private DummyNode addChild(DummyNode parent, DummyNode child) {
        parent.addChild(child, parent.getNumChildren());
        return parent;
    }

    @BeforeEach
    void setUpSampleNodeTree() {
        this.rootNode = this.newDummyNode(false);
    }

    @Test
    void testBoundaryIsHonored() {
        this.addChild(this.rootNode, this.addChild(this.newDummyNode(true), this.newDummyNode(false)));
        List descendantsOfType = this.rootNode.descendants(DummyNode.class).toList();
        Assertions.assertEquals((int)1, (int)descendantsOfType.size());
        Assertions.assertTrue((boolean)((DummyNode)((Object)descendantsOfType.get(0))).isFindBoundary());
    }

    @Test
    void testSearchFromBoundary() {
        this.addChild(this.rootNode, this.addChild(this.newDummyNode(true), this.newDummyNode(false)));
        List descendantsOfType = ((DummyNode)this.rootNode.descendants(DummyNode.class).first()).descendants(DummyNode.class).toList();
        Assertions.assertEquals((int)1, (int)descendantsOfType.size());
        Assertions.assertFalse((boolean)((DummyNode)((Object)descendantsOfType.get(0))).isFindBoundary());
    }

    @Test
    void testSearchFromBoundaryFromNonOptimisedStream() {
        this.addChild(this.rootNode, this.addChild(this.newDummyNode(true), this.newDummyNode(false)));
        List descendantsOfType = this.rootNode.descendants(DummyNode.class).take(1).descendants(DummyNode.class).toList();
        Assertions.assertEquals((int)1, (int)descendantsOfType.size());
        Assertions.assertFalse((boolean)((DummyNode)((Object)descendantsOfType.get(0))).isFindBoundary());
    }

    @Test
    void testSearchIgnoringBoundary() {
        this.addChild(this.rootNode, this.addChild(this.newDummyNode(true), this.newDummyNode(false)));
        List descendantsOfType = this.rootNode.descendants(DummyNode.class).crossFindBoundaries().toList();
        Assertions.assertEquals((int)2, (int)descendantsOfType.size());
        Assertions.assertTrue((boolean)((DummyNode)((Object)descendantsOfType.get(0))).isFindBoundary());
        Assertions.assertFalse((boolean)((DummyNode)((Object)descendantsOfType.get(1))).isFindBoundary());
    }
}

