/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LanguageRegistryTest {
    private final LanguageRegistry languageRegistry = LanguageRegistry.PMD;

    LanguageRegistryTest() {
    }

    @Test
    void getDefaultVersionLanguageTest() {
        Language dummy = this.languageRegistry.getLanguageById("dummy");
        LanguageVersion dummy12 = dummy.getVersion("1.2");
        Assertions.assertNotNull((Object)dummy12);
        LanguageVersion dummyDefault = dummy.getDefaultVersion();
        Assertions.assertNotNull((Object)dummyDefault);
        Assertions.assertNotSame((Object)dummy12, (Object)dummyDefault);
    }

    @Test
    void getLanguageVersionByAliasTest() {
        Language dummy = this.languageRegistry.getLanguageById("dummy");
        LanguageVersion dummy17 = dummy.getVersion("1.7");
        Assertions.assertNotNull((Object)dummy17);
        Assertions.assertEquals((Object)"1.7", (Object)dummy17.getVersion());
        LanguageVersion dummy7 = dummy.getVersion("7");
        Assertions.assertNotNull((Object)dummy7);
        Assertions.assertEquals((Object)"1.7", (Object)dummy17.getVersion());
        Assertions.assertSame((Object)dummy17, (Object)dummy7);
    }
}

