/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.Objects;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.cpd.CpdLanguageProperties;
import net.sourceforge.pmd.lang.AbstractPmdLanguageVersionHandler;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.impl.SimpleLanguageModuleBase;
import net.sourceforge.pmd.reporting.ViolationDecorator;

public class DummyLanguageModule
extends SimpleLanguageModuleBase
implements CpdCapableLanguage {
    public static final String NAME = "Dummy";
    public static final String TERSE_NAME = "dummy";
    private static final String PARSER_THROWS = "parserThrows";

    public DummyLanguageModule() {
        super(LanguageModuleBase.LanguageMetadata.withId((String)TERSE_NAME).name(NAME).extensions(TERSE_NAME, new String[]{"txt"}).addVersion("1.0", new String[0]).addVersion("1.1", new String[0]).addVersion("1.2", new String[0]).addVersion("1.3", new String[0]).addVersion("1.4", new String[0]).addVersion("1.5", new String[]{"5"}).addVersion("1.6", new String[]{"6"}).addDefaultVersion("1.7", new String[]{"7"}).addVersion(PARSER_THROWS, new String[0]).addVersion("1.8", new String[]{"8"}), (LanguageVersionHandler)new Handler());
    }

    public static DummyLanguageModule getInstance() {
        return (DummyLanguageModule)Objects.requireNonNull(LanguageRegistry.PMD.getLanguageByFullName(NAME));
    }

    public LanguagePropertyBundle newPropertyBundle() {
        LanguagePropertyBundle bundle = super.newPropertyBundle();
        bundle.definePropertyDescriptor(CpdLanguageProperties.CPD_ANONYMIZE_LITERALS);
        bundle.definePropertyDescriptor(CpdLanguageProperties.CPD_ANONYMIZE_IDENTIFIERS);
        return bundle;
    }

    public LanguageVersion getVersionWhereParserThrows() {
        return this.getVersion(PARSER_THROWS);
    }

    public static DummyNode.DummyRootNode readLispNode(Parser.ParserTask task) {
        TextDocument document = task.getTextDocument();
        DummyNode.DummyRootNode root = new DummyNode.DummyRootNode().withTaskInfo(task);
        root.setRegion(document.getEntireRegion());
        DummyNode top = root;
        int lastNodeStart = 0;
        Chars text = document.getText();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '(') {
                DummyNode node = text.startsWith("#text", i + 1) ? new DummyNode.DummyTextNode() : (text.startsWith("#comment", i + 1) ? new DummyNode.DummyCommentNode() : new DummyNode());
                node.setParent(top);
                top.addChild(node, top.getNumChildren());
                node.setRegion(TextRegion.caretAt((int)i));
                if (top.getImage() == null) {
                    String image = text.substring(lastNodeStart, i);
                    top.setImage(image);
                }
                lastNodeStart = i + 1;
                top = node;
                continue;
            }
            if (c != ')') continue;
            if (top == null) {
                throw new ParseException("Unbalanced parentheses: " + text);
            }
            top.setRegion(TextRegion.fromBothOffsets((int)top.getTextRegion().getStartOffset(), (int)i));
            if (top.getImage() == null) {
                String image = text.substring(lastNodeStart, i);
                top.setImage(image);
                lastNodeStart = i + 1;
            }
            top = (DummyNode)top.getParent();
        }
        if (top != root) {
            throw new ParseException("Unbalanced parentheses: " + text);
        }
        return root;
    }

    public static class Handler
    extends AbstractPmdLanguageVersionHandler {
        public Parser getParser() {
            return task -> {
                if (task.getLanguageVersion().getVersion().equals(DummyLanguageModule.PARSER_THROWS)) {
                    throw new ParseException("ohio");
                }
                return DummyLanguageModule.readLispNode(task);
            };
        }

        public ViolationDecorator getViolationDecorator() {
            return (node, data) -> data.put("packageName", "foo");
        }
    }
}

