/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sourceforge.pmd.internal.util.ClasspathClassLoader;
import net.sourceforge.pmd.internal.util.IOUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ClasspathClassLoaderTest {
    @TempDir
    private Path tempDir;

    ClasspathClassLoaderTest() {
    }

    @Test
    void loadEmptyClasspathWithParent() throws IOException {
        try (ClasspathClassLoader loader = new ClasspathClassLoader("", ClasspathClassLoader.class.getClassLoader());
             InputStream resource = loader.getResourceAsStream("java/lang/Object.class");){
            Assertions.assertNotNull((Object)resource);
            try (DataInputStream data = new DataInputStream(resource);){
                this.assertClassFile(data, Integer.valueOf(System.getProperty("java.specification.version")));
            }
        }
    }

    @Test
    void loadEmptyClasspathNoParent() throws IOException {
        try (ClasspathClassLoader loader = new ClasspathClassLoader("", null);
             InputStream resource = loader.getResourceAsStream("java/lang/Object.class");){
            Assertions.assertNotNull((Object)resource);
            try (DataInputStream data = new DataInputStream(resource);){
                this.assertClassFile(data, Integer.valueOf(System.getProperty("java.specification.version")));
            }
        }
    }

    @Test
    void loadFromJar() throws IOException {
        String RESOURCE_NAME = "net/sourceforge/pmd/Sample.txt";
        String TEST_CONTENT = "Test\n";
        Path jarPath = this.tempDir.resolve("custom.jar");
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(jarPath, new OpenOption[0]));){
            out.putNextEntry(new ZipEntry("net/sourceforge/pmd/Sample.txt"));
            out.write("Test\n".getBytes(StandardCharsets.UTF_8));
        }
        String classpath = jarPath.toString();
        try (ClasspathClassLoader loader = new ClasspathClassLoader(classpath, null);
             InputStream in = loader.getResourceAsStream("net/sourceforge/pmd/Sample.txt");){
            Assertions.assertNotNull((Object)in);
            String s = IOUtil.readToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)"Test\n", (Object)s);
        }
    }

    @ParameterizedTest
    @ValueSource(ints={11, 17, 21})
    void loadFromJava(int javaVersion) throws IOException {
        Path javaHome = Paths.get(System.getProperty("user.home"), "openjdk" + javaVersion);
        Assumptions.assumeTrue((boolean)Files.isDirectory(javaHome, new LinkOption[0]), (String)("Couldn't find java" + javaVersion + " installation at " + javaHome));
        Path jrtfsPath = javaHome.resolve("lib/jrt-fs.jar");
        Assertions.assertTrue((boolean)Files.isRegularFile(jrtfsPath, new LinkOption[0]), (String)("java" + javaVersion + " installation is incomplete. " + jrtfsPath + " not found!"));
        String classPath = jrtfsPath.toString();
        try (ClasspathClassLoader loader = new ClasspathClassLoader(classPath, null);){
            Assertions.assertEquals((Object)javaHome.toString(), (Object)loader.javaHome);
            try (InputStream stream = loader.getResourceAsStream("java/lang/Object.class");){
                Assertions.assertNotNull((Object)stream);
                try (DataInputStream data = new DataInputStream(stream);){
                    this.assertClassFile(data, javaVersion);
                }
            }
            Assertions.assertNull((Object)loader.getResourceAsStream("ClassInDefaultPackage.class"));
        }
    }

    private void assertClassFile(DataInputStream data, int javaVersion) throws IOException {
        int magicNumber = data.readInt();
        Assertions.assertEquals((int)-889275714, (int)magicNumber);
        data.readUnsignedShort();
        int majorVersion = data.readUnsignedShort();
        Assertions.assertEquals((int)(44 + javaVersion), (int)majorVersion);
    }
}

