/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CpdTestUtils;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.lang.document.FileId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XMLRendererTest {
    private static final String ENCODING = (String)System.getProperties().get("file.encoding");
    private static final String FORM_FEED = "\f";
    private static final String FORM_FEED_ENTITY = "&#12;";

    XMLRendererTest() {
    }

    @Test
    void testWithNoDuplication() throws IOException, ParserConfigurationException, SAXException {
        XMLRenderer renderer = new XMLRenderer();
        StringWriter sw = new StringWriter();
        renderer.render(CpdTestUtils.makeReport(Collections.emptyList()), (Writer)sw);
        String report = sw.toString();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes(ENCODING)));
        NodeList nodes = doc.getChildNodes();
        Node n = nodes.item(0);
        Assertions.assertEquals((Object)"pmd-cpd", (Object)n.getNodeName());
        Assertions.assertEquals((int)0, (int)doc.getElementsByTagName("duplication").getLength());
    }

    @Test
    void testWithOneDuplication() throws Exception {
        Node file;
        XMLRenderer renderer = new XMLRenderer();
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        int lineCount = 6;
        FileId foo1 = CpdTestUtils.FOO_FILE_ID;
        Mark mark1 = builder.createMark("public", foo1, 1, lineCount);
        Mark mark2 = builder.createMark("stuff", foo1, 73, lineCount);
        builder.addMatch(new Match(75, mark1, mark2));
        StringWriter sw = new StringWriter();
        renderer.render(builder.build(), (Writer)sw);
        String report = sw.toString();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes(ENCODING)));
        NodeList dupes = doc.getElementsByTagName("duplication");
        Assertions.assertEquals((int)1, (int)dupes.getLength());
        for (file = dupes.item(0).getFirstChild(); file != null && file.getNodeType() != 1; file = file.getNextSibling()) {
        }
        if (file != null) {
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("line").getNodeValue());
            Assertions.assertEquals((Object)foo1.getAbsolutePath(), (Object)file.getAttributes().getNamedItem("path").getNodeValue());
            Assertions.assertEquals((Object)"6", (Object)file.getAttributes().getNamedItem("endline").getNodeValue());
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("column").getNodeValue());
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("endcolumn").getNodeValue());
            for (file = file.getNextSibling(); file != null && file.getNodeType() != 1; file = file.getNextSibling()) {
            }
        }
        if (file != null) {
            Assertions.assertEquals((Object)"73", (Object)file.getAttributes().getNamedItem("line").getNodeValue());
            Assertions.assertEquals((Object)"78", (Object)file.getAttributes().getNamedItem("endline").getNodeValue());
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("column").getNodeValue());
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("endcolumn").getNodeValue());
        }
        Assertions.assertEquals((int)1, (int)doc.getElementsByTagName("codefragment").getLength());
        Assertions.assertEquals((Object)CpdTestUtils.generateDummyContent(lineCount), (Object)doc.getElementsByTagName("codefragment").item(0).getTextContent());
    }

    @Test
    void testRenderWithMultipleMatch() throws Exception {
        XMLRenderer renderer = new XMLRenderer();
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        int lineCount1 = 6;
        FileId foo1 = CpdTestUtils.FOO_FILE_ID;
        Mark mark1 = builder.createMark("public", foo1, 48, lineCount1);
        Mark mark2 = builder.createMark("void", foo1, 73, lineCount1);
        builder.addMatch(new Match(75, mark1, mark2));
        int lineCount2 = 7;
        FileId foo2 = FileId.fromPathLikeString((String)"/var/Foo2.java");
        Mark mark3 = builder.createMark("void", foo2, 49, lineCount2);
        Mark mark4 = builder.createMark("stuff", foo2, 74, lineCount2);
        builder.addMatch(new Match(76, mark3, mark4));
        StringWriter sw = new StringWriter();
        renderer.render(builder.build(), (Writer)sw);
        String report = sw.toString();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes(ENCODING)));
        Assertions.assertEquals((int)2, (int)doc.getElementsByTagName("duplication").getLength());
        Assertions.assertEquals((int)4, (int)doc.getElementsByTagName("file").getLength());
    }

    @Test
    void testWithOneDuplicationWithColumns() throws Exception {
        Node file;
        XMLRenderer renderer = new XMLRenderer();
        int lineCount = 2;
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        FileId fileName = CpdTestUtils.FOO_FILE_ID;
        Mark mark1 = builder.createMark("public", fileName, 1, lineCount, 2, 3);
        Mark mark2 = builder.createMark("stuff", fileName, 24, lineCount, 4, 5);
        builder.addMatch(new Match(75, mark1, mark2));
        StringWriter sw = new StringWriter();
        renderer.render(builder.build(), (Writer)sw);
        String report = sw.toString();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes(ENCODING)));
        NodeList dupes = doc.getElementsByTagName("duplication");
        Assertions.assertEquals((int)1, (int)dupes.getLength());
        for (file = dupes.item(0).getFirstChild(); file != null && file.getNodeType() != 1; file = file.getNextSibling()) {
        }
        if (file != null) {
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("line").getNodeValue());
            Assertions.assertEquals((Object)fileName.getAbsolutePath(), (Object)file.getAttributes().getNamedItem("path").getNodeValue());
            Assertions.assertEquals((Object)"2", (Object)file.getAttributes().getNamedItem("endline").getNodeValue());
            Assertions.assertEquals((Object)"2", (Object)file.getAttributes().getNamedItem("column").getNodeValue());
            Assertions.assertEquals((Object)"3", (Object)file.getAttributes().getNamedItem("endcolumn").getNodeValue());
            for (file = file.getNextSibling(); file != null && file.getNodeType() != 1; file = file.getNextSibling()) {
            }
        }
        if (file != null) {
            Assertions.assertEquals((Object)"24", (Object)file.getAttributes().getNamedItem("line").getNodeValue());
            Assertions.assertEquals((Object)"25", (Object)file.getAttributes().getNamedItem("endline").getNodeValue());
            Assertions.assertEquals((Object)"4", (Object)file.getAttributes().getNamedItem("column").getNodeValue());
            Assertions.assertEquals((Object)"5", (Object)file.getAttributes().getNamedItem("endcolumn").getNodeValue());
        }
        Assertions.assertEquals((int)1, (int)doc.getElementsByTagName("codefragment").getLength());
        Assertions.assertEquals((Object)CpdTestUtils.generateDummyContent(2), (Object)doc.getElementsByTagName("codefragment").item(0).getTextContent());
    }

    @Test
    void testRendererEncodedPath() throws IOException {
        XMLRenderer renderer = new XMLRenderer();
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        String escapeChar = "&amp;";
        Mark mark1 = builder.createMark("public", FileId.fromPathLikeString((String)"/var/A&oo.java"), 2, 6);
        Mark mark2 = builder.createMark("void", FileId.fromPathLikeString((String)"/var/B&oo.java"), 17, 6);
        builder.addMatch(new Match(75, mark1, mark2));
        StringWriter sw = new StringWriter();
        renderer.render(builder.build(), (Writer)sw);
        String report = sw.toString();
        MatcherAssert.assertThat((Object)report, (Matcher)Matchers.containsString((String)"&amp;"));
    }

    @Test
    void testFilesWithNumberOfTokens() throws IOException, ParserConfigurationException, SAXException {
        XMLRenderer renderer = new XMLRenderer();
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        FileId filename = CpdTestUtils.FOO_FILE_ID;
        int lineCount = 2;
        Mark mark1 = builder.createMark("public", filename, 1, 2, 2, 3);
        Mark mark2 = builder.createMark("stuff", filename, 3, 2, 4, 5);
        builder.addMatch(new Match(75, mark1, mark2));
        builder.recordNumTokens(filename, 888);
        CPDReport report = builder.build();
        StringWriter writer = new StringWriter();
        renderer.render(report, (Writer)writer);
        String xmlOutput = writer.toString();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xmlOutput.getBytes(ENCODING)));
        NodeList files = doc.getElementsByTagName("file");
        Node file = files.item(0);
        NamedNodeMap attributes = file.getAttributes();
        Assertions.assertEquals((Object)CpdTestUtils.FOO_FILE_ID.getAbsolutePath(), (Object)attributes.getNamedItem("path").getNodeValue());
        Assertions.assertEquals((Object)"888", (Object)attributes.getNamedItem("totalNumberOfTokens").getNodeValue());
    }

    @Test
    void testGetDuplicationStartEnd() throws IOException, ParserConfigurationException, SAXException {
        XMLRenderer renderer = new XMLRenderer();
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        FileId filename = CpdTestUtils.FOO_FILE_ID;
        int lineCount = 6;
        Mark mark1 = builder.createMark("public", filename, 1, 6, 2, 3);
        Mark mark2 = builder.createMark("stuff", filename, 73, 6, 4, 5);
        builder.addMatch(new Match(75, mark1, mark2));
        builder.recordNumTokens(filename, 888);
        CPDReport report = builder.build();
        StringWriter writer = new StringWriter();
        renderer.render(report, (Writer)writer);
        String xmlOutput = writer.toString();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xmlOutput.getBytes(ENCODING)));
        NodeList files = doc.getElementsByTagName("file");
        Node dup_1 = files.item(1);
        NamedNodeMap attrs_1 = dup_1.getAttributes();
        Assertions.assertEquals((Object)"0", (Object)attrs_1.getNamedItem("begintoken").getNodeValue());
        Assertions.assertEquals((Object)"1", (Object)attrs_1.getNamedItem("endtoken").getNodeValue());
        Node dup_2 = files.item(2);
        NamedNodeMap attrs_2 = dup_2.getAttributes();
        Assertions.assertEquals((Object)"2", (Object)attrs_2.getNamedItem("begintoken").getNodeValue());
        Assertions.assertEquals((Object)"3", (Object)attrs_2.getNamedItem("endtoken").getNodeValue());
    }

    @Test
    void testRendererXMLEscaping() throws IOException {
        String codefragment = "code fragment\f\nline2\nline3\nno & escaping necessary in CDATA\nx=\"]]>\";";
        XMLRenderer renderer = new XMLRenderer();
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        FileId file1 = FileId.fromPathLikeString((String)"file1");
        FileId file2 = FileId.fromPathLikeString((String)"file2");
        Mark mark1 = builder.createMark("public", file1, 1, 5);
        Mark mark2 = builder.createMark("public", file2, 5, 5);
        Match match1 = new Match(75, mark1, mark2);
        builder.addMatch(match1);
        builder.setFileContent(file1, codefragment);
        StringWriter sw = new StringWriter();
        renderer.render(builder.build(), (Writer)sw);
        String report = sw.toString();
        MatcherAssert.assertThat((Object)report, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)FORM_FEED)));
        MatcherAssert.assertThat((Object)report, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)FORM_FEED_ENTITY)));
        MatcherAssert.assertThat((Object)report, (Matcher)Matchers.containsString((String)"no & escaping necessary in CDATA"));
        MatcherAssert.assertThat((Object)report, (Matcher)Matchers.containsString((String)"x=\"]]]]><![CDATA[>\";"));
        MatcherAssert.assertThat((Object)report, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"x=\"]]>\";")));
    }
}

