/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SourceManager;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MatchAlgorithmTest {
    private static final String LINE_1 = "public class Foo { ";
    private static final String LINE_2 = " public void bar() {";
    private static final String LINE_3 = "  System.out.println(\"hello\");";
    private static final String LINE_4 = "  System.out.println(\"hello\");";
    private static final String LINE_5 = "  int i = 5";
    private static final String LINE_6 = "  System.out.print(\"hello\");";
    private static final String LINE_7 = " }";
    private static final String LINE_8 = "}";

    MatchAlgorithmTest() {
    }

    private static String getSampleCode() {
        return "public class Foo { \n public void bar() {\n  System.out.println(\"hello\");\n  System.out.println(\"hello\");\n  int i = 5\n  System.out.print(\"hello\");\n }\n}";
    }

    @Test
    void testSimple() throws IOException {
        DummyLanguageModule dummy = DummyLanguageModule.getInstance();
        CpdLexer cpdLexer = dummy.createCpdLexer(dummy.newPropertyBundle());
        FileId fileName = FileId.fromPathLikeString((String)"Foo.dummy");
        TextFile textFile = TextFile.forCharSeq((CharSequence)MatchAlgorithmTest.getSampleCode(), (FileId)fileName, (LanguageVersion)dummy.getDefaultVersion());
        SourceManager sourceManager = new SourceManager(CollectionUtil.listOf((Object)textFile, (Object[])new TextFile[0]));
        Tokens tokens = new Tokens();
        TextDocument sourceCode = sourceManager.get(textFile);
        CpdLexer.tokenize((CpdLexer)cpdLexer, (TextDocument)sourceCode, (Tokens)tokens);
        Assertions.assertEquals((int)44, (int)tokens.size());
        MatchAlgorithm matchAlgorithm = new MatchAlgorithm(tokens, 5);
        List matches = matchAlgorithm.findMatches((CPDListener)new CPDNullListener(), sourceManager);
        Assertions.assertEquals((int)1, (int)matches.size());
        Match match = (Match)matches.get(0);
        Iterator marks = match.iterator();
        Mark mark1 = (Mark)marks.next();
        Mark mark2 = (Mark)marks.next();
        Assertions.assertFalse((boolean)marks.hasNext());
        Assertions.assertEquals((int)3, (int)mark1.getLocation().getStartLine());
        Assertions.assertEquals((Object)fileName, (Object)mark1.getLocation().getFileId());
        Assertions.assertEquals((Object)"  System.out.println(\"hello\");\n", (Object)sourceManager.getSlice(mark1).toString());
        Assertions.assertEquals((int)4, (int)mark2.getLocation().getStartLine());
        Assertions.assertEquals((Object)fileName, (Object)mark2.getLocation().getFileId());
        Assertions.assertEquals((Object)"  System.out.println(\"hello\");\n", (Object)sourceManager.getSlice(mark2).toString());
    }
}

