/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SourceManager;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;

final class CpdTestUtils {
    public static final FileId FOO_FILE_ID = FileId.fromPathLikeString((String)"/var/Foo.java");
    public static final FileId BAR_FILE_ID = FileId.fromPathLikeString((String)"/var/Bar.java");
    public static final String DUMMY_FILE_CONTENT = CpdTestUtils.generateDummyContent(60);

    private CpdTestUtils() {
    }

    static CPDReport makeReport(List<Match> matches) {
        return CpdTestUtils.makeReport(matches, Collections.emptyMap());
    }

    static CPDReport makeReport(List<Match> matches, Map<FileId, Integer> numTokensPerFile) {
        HashSet textFiles = new HashSet();
        for (Match match : matches) {
            match.iterator().forEachRemaining(mark -> textFiles.add(TextFile.forCharSeq((CharSequence)DUMMY_FILE_CONTENT, (FileId)mark.getLocation().getFileId(), (LanguageVersion)DummyLanguageModule.getInstance().getDefaultVersion())));
        }
        return new CPDReport(new SourceManager(new ArrayList(textFiles)), matches, numTokensPerFile);
    }

    static String generateDummyContent(int lengthInLines) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lengthInLines; ++i) {
            for (int j = 0; j < 10; ++j) {
                sb.append(i).append("_");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    static class CpdReportBuilder {
        private final Map<FileId, String> fileContents = new HashMap<FileId, String>();
        final Tokens tokens = new Tokens();
        private final List<Match> matches = new ArrayList<Match>();
        private Map<FileId, Integer> numTokensPerFile = new HashMap<FileId, Integer>();

        CpdReportBuilder() {
        }

        CpdReportBuilder setFileContent(FileId fileName, String content) {
            this.fileContents.put(fileName, content);
            return this;
        }

        public CpdReportBuilder setNumTokensPerFile(Map<FileId, Integer> numTokensPerFile) {
            this.numTokensPerFile = numTokensPerFile;
            return this;
        }

        public CpdReportBuilder recordNumTokens(FileId fileName, int numTokens) {
            this.numTokensPerFile.put(fileName, numTokens);
            return this;
        }

        CPDReport build() {
            HashSet textFiles = new HashSet();
            this.fileContents.forEach((fname, contents) -> textFiles.add(TextFile.forCharSeq((CharSequence)contents, (FileId)fname, (LanguageVersion)DummyLanguageModule.getInstance().getDefaultVersion())));
            return new CPDReport(new SourceManager(new ArrayList(textFiles)), this.matches, this.numTokensPerFile);
        }

        Mark createMark(String image, FileId fileName, int beginLine, int lineCount) {
            this.fileContents.putIfAbsent(fileName, DUMMY_FILE_CONTENT);
            return new Mark(this.tokens.addToken(image, fileName, beginLine, 1, beginLine + lineCount - 1, 1));
        }

        CpdReportBuilder addMatch(Match match) {
            this.fileContents.putIfAbsent(match.getFirstMark().getLocation().getFileId(), DUMMY_FILE_CONTENT);
            this.matches.add(match);
            return this;
        }

        Mark createMark(String image, FileId fileId, int beginLine, int lineCount, int beginColumn, int endColumn) {
            this.fileContents.putIfAbsent(fileId, DUMMY_FILE_CONTENT);
            TokenEntry beginToken = this.tokens.addToken(image, fileId, beginLine, beginColumn, beginLine, beginColumn + image.length());
            TokenEntry endToken = this.tokens.addToken(image, fileId, beginLine + lineCount - 1, beginColumn, beginLine + lineCount - 1, endColumn);
            Mark result = new Mark(beginToken);
            result.setEndToken(endToken);
            return result;
        }
    }
}

