/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CpdAnalysisTest {
    private static final String BASE_TEST_RESOURCE_PATH = "src/test/resources/net/sourceforge/pmd/cpd/files/";
    private static final String TARGET_TEST_RESOURCE_PATH = "target/classes/net/sourceforge/pmd/cpd/files/";
    private boolean canTestSymLinks = SystemUtils.IS_OS_UNIX;
    CPDConfiguration config = new CPDConfiguration();

    CpdAnalysisTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.config.setOnlyRecognizeLanguage((Language)DummyLanguageModule.getInstance());
        this.config.setMinimumTileSize(10);
    }

    private void prepareSymLinks() throws Exception {
        Assumptions.assumeTrue((boolean)this.canTestSymLinks, (String)"Skipping unit tests with symlinks.");
        Runtime runtime = Runtime.getRuntime();
        if (!new File(TARGET_TEST_RESOURCE_PATH, "symlink-for-real-file.txt").exists()) {
            runtime.exec(new String[]{"ln", "-s", "src/test/resources/net/sourceforge/pmd/cpd/files/real-file.txt", "target/classes/net/sourceforge/pmd/cpd/files/symlink-for-real-file.txt"}).waitFor();
        }
        if (!new File(BASE_TEST_RESOURCE_PATH, "this-is-a-broken-sym-link-for-test").exists()) {
            runtime.exec(new String[]{"ln", "-s", "broken-sym-link", "target/classes/net/sourceforge/pmd/cpd/files/this-is-a-broken-sym-link-for-test"}).waitFor();
        }
    }

    @Test
    void testFileSectionWithBrokenSymlinks() throws Exception {
        this.prepareSymLinks();
        FileCountAssertListener listener = new FileCountAssertListener(0);
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)this.config);){
            cpd.setCpdListener((CPDListener)listener);
            Assertions.assertFalse((boolean)cpd.files().addFile(Paths.get(BASE_TEST_RESOURCE_PATH, "this-is-a-broken-sym-link-for-test")));
            cpd.performAnalysis();
        }
        listener.verify();
    }

    @Test
    void testFileAddedAsSymlinkAndReal() throws Exception {
        this.prepareSymLinks();
        FileCountAssertListener listener = new FileCountAssertListener(1);
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)this.config);){
            cpd.setCpdListener((CPDListener)listener);
            Assertions.assertTrue((boolean)cpd.files().addFile(Paths.get(BASE_TEST_RESOURCE_PATH, "real-file.txt")));
            Assertions.assertFalse((boolean)cpd.files().addFile(Paths.get(BASE_TEST_RESOURCE_PATH, "symlink-for-real-file.txt")));
            cpd.performAnalysis();
        }
        listener.verify();
    }

    @Test
    void testNoFileAddedAsSymlink() throws Exception {
        this.prepareSymLinks();
        FileCountAssertListener listener = new FileCountAssertListener(0);
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)this.config);){
            cpd.setCpdListener((CPDListener)listener);
            Assertions.assertFalse((boolean)cpd.files().addFile(Paths.get(BASE_TEST_RESOURCE_PATH, "symlink-for-real-file.txt")));
            cpd.performAnalysis();
        }
        listener.verify();
    }

    @Test
    void testFileAddedWithRelativePath() throws Exception {
        FileCountAssertListener listener = new FileCountAssertListener(1);
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)this.config);){
            cpd.setCpdListener((CPDListener)listener);
            Assertions.assertTrue((boolean)cpd.files().addFile(Paths.get("./src/test/resources/net/sourceforge/pmd/cpd/files/", "real-file.txt")));
            cpd.performAnalysis();
        }
        listener.verify();
    }

    @Test
    void testFileOrderRelevance() throws Exception {
        Path dup1 = Paths.get("./src/test/resources/net/sourceforge/pmd/cpd/files/", "dup1.txt");
        Path dup2 = Paths.get("./src/test/resources/net/sourceforge/pmd/cpd/files/", "dup2.txt");
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)this.config);){
            Assertions.assertTrue((boolean)cpd.files().addFile(dup2));
            Assertions.assertTrue((boolean)cpd.files().addFile(dup1));
            cpd.performAnalysis(report -> {
                List matches = report.getMatches();
                Assertions.assertFalse((boolean)matches.isEmpty());
                for (Match match : matches) {
                    Assertions.assertEquals((Object)"dup1.txt", (Object)match.getFirstMark().getFileId().getFileName());
                    Assertions.assertEquals((Object)"dup2.txt", (Object)match.getSecondMark().getFileId().getFileName());
                }
            });
        }
        cpd = CpdAnalysis.create((CPDConfiguration)this.config);
        try {
            Assertions.assertTrue((boolean)cpd.files().addFile(dup1));
            Assertions.assertTrue((boolean)cpd.files().addFile(dup2));
            cpd.performAnalysis(report -> {
                List matches = report.getMatches();
                Assertions.assertFalse((boolean)matches.isEmpty());
                for (Match match : matches) {
                    Assertions.assertEquals((Object)"dup1.txt", (Object)match.getFirstMark().getFileId().getFileName());
                    Assertions.assertEquals((Object)"dup2.txt", (Object)match.getSecondMark().getFileId().getFileName());
                }
            });
        }
        finally {
            if (cpd != null) {
                cpd.close();
            }
        }
    }

    private static class FileCountAssertListener
    implements CPDListener {
        private int expectedFilesCount;
        private int files;

        FileCountAssertListener(int expectedFilesCount) {
            this.expectedFilesCount = expectedFilesCount;
            this.files = 0;
        }

        public void addedFile(int fileCount) {
            ++this.files;
            if (this.files > this.expectedFilesCount) {
                Assertions.fail((String)"File was added!");
            }
        }

        public void phaseUpdate(int phase) {
        }

        public void verify() {
            Assertions.assertEquals((int)this.expectedFilesCount, (int)this.files, (String)("Expected " + this.expectedFilesCount + " files, but " + this.files + " have been added."));
        }
    }
}

