/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CpdTestUtils;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CPDReportTest {
    CPDReportTest() {
    }

    @Test
    void testFilterMatches() {
        CpdTestUtils.CpdReportBuilder reportBuilder = new CpdTestUtils.CpdReportBuilder();
        FileId file1 = FileId.fromPathLikeString((String)"file1.java");
        FileId file2 = FileId.fromPathLikeString((String)"file2.java");
        FileId file3 = FileId.fromPathLikeString((String)"file3.java");
        reportBuilder.addMatch(this.createMatch(reportBuilder, file1, file2, 1));
        reportBuilder.addMatch(this.createMatch(reportBuilder, file1, file3, 2));
        reportBuilder.addMatch(this.createMatch(reportBuilder, file2, file3, 3));
        reportBuilder.recordNumTokens(file1, 10);
        reportBuilder.recordNumTokens(file2, 15);
        reportBuilder.recordNumTokens(file3, 20);
        CPDReport original = reportBuilder.build();
        Assertions.assertEquals((int)3, (int)original.getMatches().size());
        CPDReport filtered = original.filterMatches(match -> CollectionUtil.any((Iterable)match, mark -> mark.getLocation().getFileId().equals((Object)file1)));
        Assertions.assertEquals((int)2, (int)filtered.getMatches().size());
        for (Match match2 : filtered.getMatches()) {
            boolean containsFile1 = match2.getMarkSet().stream().map(Mark::getFileId).anyMatch(arg_0 -> ((FileId)file1).equals(arg_0));
            Assertions.assertTrue((boolean)containsFile1);
        }
        Assertions.assertEquals((Object)original.getNumberOfTokensPerFile(), (Object)filtered.getNumberOfTokensPerFile());
    }

    private Match createMatch(CpdTestUtils.CpdReportBuilder builder, FileId file1, FileId file2, int line) {
        return new Match(5, builder.tokens.addToken("firstToken", file1, line, 1, line, 1), builder.tokens.addToken("secondToken", file2, line, 2, line, 2));
    }
}

