/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CPDFilelistTest {
    CPDFilelistTest() {
    }

    @Test
    void testFilelist() throws IOException {
        CPDFilelistTest.testFileList("src/test/resources/net/sourceforge/pmd/cpd/cli/filelist.txt");
    }

    @Test
    void testFilelistMultipleLines() throws IOException {
        CPDFilelistTest.testFileList("src/test/resources/net/sourceforge/pmd/cpd/cli/filelist2.txt");
    }

    private static void testFileList(String first) throws IOException {
        List paths;
        CPDConfiguration arguments = new CPDConfiguration();
        arguments.setOnlyRecognizeLanguage((Language)DummyLanguageModule.getInstance());
        arguments.setInputFilePath(Paths.get(first, new String[0]));
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)arguments);){
            paths = CollectionUtil.map((Collection)cpd.files().getCollectedFiles(), TextFile::getFileId);
        }
        Assertions.assertEquals((int)2, (int)paths.size());
        List simpleNames = CollectionUtil.map((Collection)paths, FileId::getFileName);
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"anotherfile.dummy", (Object[])new String[]{"somefile.dummy"}), (Object)simpleNames);
    }
}

