/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.CSVWithLinecountPerFileRenderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.VSRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CPDConfigurationTest {
    CPDConfigurationTest() {
    }

    @Test
    void testRenderers() {
        HashMap<String, Class<SimpleRenderer>> renderersToTest = new HashMap<String, Class<SimpleRenderer>>();
        renderersToTest.put("csv", CSVRenderer.class);
        renderersToTest.put("xml", XMLRenderer.class);
        renderersToTest.put("csv_with_linecount_per_file", CSVWithLinecountPerFileRenderer.class);
        renderersToTest.put("vs", VSRenderer.class);
        renderersToTest.put("text", SimpleRenderer.class);
        for (Map.Entry entry : renderersToTest.entrySet()) {
            CPDReportRenderer r = CPDConfiguration.createRendererByName((String)((String)entry.getKey()), (Charset)StandardCharsets.UTF_8);
            Assertions.assertNotNull((Object)r);
            Assertions.assertSame(entry.getValue(), r.getClass());
        }
    }

    @Test
    void testRendererEncoding() {
        CPDConfiguration conf = new CPDConfiguration();
        conf.setRendererName("xml");
        conf.setSourceEncoding(StandardCharsets.UTF_16);
        CPDReportRenderer renderer = conf.getCPDReportRenderer();
        Assertions.assertNotNull((Object)renderer);
        MatcherAssert.assertThat((Object)renderer, (Matcher)Matchers.instanceOf(XMLRenderer.class));
        Assertions.assertEquals((Object)StandardCharsets.UTF_16.name(), (Object)((XMLRenderer)renderer).getEncoding());
    }

    @Test
    void testRendererEncoding2() {
        CPDConfiguration conf = new CPDConfiguration();
        conf.setSourceEncoding(StandardCharsets.UTF_16);
        conf.setRendererName("xml");
        CPDReportRenderer renderer = conf.getCPDReportRenderer();
        Assertions.assertNotNull((Object)renderer);
        MatcherAssert.assertThat((Object)renderer, (Matcher)Matchers.instanceOf(XMLRenderer.class));
        Assertions.assertEquals((Object)StandardCharsets.UTF_16.name(), (Object)((XMLRenderer)renderer).getEncoding());
    }
}

