/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import net.sourceforge.pmd.cache.internal.ClasspathEntryFingerprinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
abstract class AbstractClasspathEntryFingerprinterTest {
    @TempDir
    Path tempDir;
    protected ClasspathEntryFingerprinter fingerprinter = this.newFingerPrinter();
    protected Checksum checksum = new Adler32();

    AbstractClasspathEntryFingerprinterTest() {
    }

    @BeforeEach
    void setUp() {
        this.checksum.reset();
    }

    protected abstract ClasspathEntryFingerprinter newFingerPrinter();

    protected abstract String[] getValidFileExtensions();

    protected abstract String[] getInvalidFileExtensions();

    protected abstract File createValidNonEmptyFile() throws IOException;

    @Test
    void appliesToNullIsSafe() {
        this.fingerprinter.appliesTo(null);
    }

    @ParameterizedTest
    @MethodSource(value={"getValidFileExtensions"})
    void appliesToValidFile(String extension) {
        Assertions.assertTrue((boolean)this.fingerprinter.appliesTo(extension));
    }

    @ParameterizedTest
    @MethodSource(value={"getInvalidFileExtensions"})
    void doesNotApplyToInvalidFile(String extension) {
        Assertions.assertFalse((boolean)this.fingerprinter.appliesTo(extension));
    }

    @Test
    void fingerprintNonExistingFile() throws MalformedURLException, IOException {
        long prevValue = this.checksum.getValue();
        this.fingerprinter.fingerprint(new File("non-existing").toURI().toURL(), this.checksum);
        Assertions.assertEquals((long)prevValue, (long)this.checksum.getValue());
    }

    @Test
    void fingerprintExistingValidFile() throws IOException {
        long prevValue = this.checksum.getValue();
        File file = this.createValidNonEmptyFile();
        Assertions.assertNotEquals((long)prevValue, (long)this.updateFingerprint(file));
    }

    protected long updateFingerprint(File file) throws MalformedURLException, IOException {
        this.fingerprinter.fingerprint(file.toURI().toURL(), this.checksum);
        return this.checksum.getValue();
    }
}

