/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Properties;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.cache.internal.AnalysisCache;
import net.sourceforge.pmd.cache.internal.FileAnalysisCache;
import net.sourceforge.pmd.cache.internal.NoopAnalysisCache;
import net.sourceforge.pmd.internal.util.ClasspathClassLoader;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.CollectionUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PmdConfigurationTest {
    PmdConfigurationTest() {
    }

    @Test
    void testSuppressMarker() {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertEquals((Object)"NOPMD", (Object)configuration.getSuppressMarker(), (String)"Default suppress marker");
        configuration.setSuppressMarker("CUSTOM_MARKER");
        Assertions.assertEquals((Object)"CUSTOM_MARKER", (Object)configuration.getSuppressMarker(), (String)"Changed suppress marker");
    }

    @Test
    void testThreads() {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertEquals((int)Runtime.getRuntime().availableProcessors(), (int)configuration.getThreads(), (String)"Default threads");
        configuration.setThreads(0);
        Assertions.assertEquals((int)0, (int)configuration.getThreads(), (String)"Changed threads");
    }

    @Test
    void testClassLoader() {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertEquals((Object)PMDConfiguration.class.getClassLoader(), (Object)configuration.getClassLoader(), (String)"Default ClassLoader");
        configuration.prependAuxClasspath("some.jar");
        Assertions.assertEquals(ClasspathClassLoader.class, configuration.getClassLoader().getClass(), (String)"Prepended ClassLoader class");
        URL[] urls = ((ClasspathClassLoader)configuration.getClassLoader()).getURLs();
        Assertions.assertEquals((int)1, (int)urls.length, (String)"urls length");
        Assertions.assertTrue((boolean)urls[0].toString().endsWith("/some.jar"), (String)"url[0]");
        Assertions.assertEquals((Object)PMDConfiguration.class.getClassLoader(), (Object)configuration.getClassLoader().getParent(), (String)"parent classLoader");
        configuration.setClassLoader(null);
        Assertions.assertEquals((Object)PMDConfiguration.class.getClassLoader(), (Object)configuration.getClassLoader(), (String)"Revert to default ClassLoader");
    }

    @Test
    void auxClasspathWithRelativeFileEmpty() {
        String relativeFilePath = "src/test/resources/net/sourceforge/pmd/auxclasspath-empty.cp";
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.prependAuxClasspath("file:" + relativeFilePath);
        URL[] urls = ((ClasspathClassLoader)configuration.getClassLoader()).getURLs();
        Assertions.assertEquals((int)0, (int)urls.length);
    }

    @Test
    void auxClasspathWithRelativeFileEmpty2() {
        String relativeFilePath = "./src/test/resources/net/sourceforge/pmd/auxclasspath-empty.cp";
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.prependAuxClasspath("file:" + relativeFilePath);
        URL[] urls = ((ClasspathClassLoader)configuration.getClassLoader()).getURLs();
        Assertions.assertEquals((int)0, (int)urls.length);
    }

    @Test
    void auxClasspathWithRelativeFile() throws URISyntaxException {
        String FILE_SCHEME = "file";
        String currentWorkingDirectory = new File("").getAbsoluteFile().toURI().getPath();
        String relativeFilePath = "src/test/resources/net/sourceforge/pmd/auxclasspath.cp";
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.prependAuxClasspath("file:" + relativeFilePath);
        URL[] urls = ((ClasspathClassLoader)configuration.getClassLoader()).getURLs();
        Object[] uris = new URI[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            uris[i] = urls[i].toURI();
        }
        Object[] expectedUris = new URI[]{new URI("file", null, currentWorkingDirectory + "lib1.jar", null), new URI("file", null, currentWorkingDirectory + "other/directory/lib2.jar", null), new URI("file", null, new File("/home/jondoe/libs/lib3.jar").getAbsoluteFile().toURI().getPath(), null), new URI("file", null, currentWorkingDirectory + "classes", null), new URI("file", null, currentWorkingDirectory + "classes2", null), new URI("file", null, new File("/home/jondoe/classes").getAbsoluteFile().toURI().getPath(), null), new URI("file", null, currentWorkingDirectory, null), new URI("file", null, currentWorkingDirectory + "relative source dir/bar", null)};
        Assertions.assertArrayEquals((Object[])expectedUris, (Object[])uris);
    }

    @Test
    void testRuleSets() {
        PMDConfiguration configuration = new PMDConfiguration();
        MatcherAssert.assertThat((Object)configuration.getRuleSetPaths(), (Matcher)Matchers.empty());
        configuration.setRuleSets(CollectionUtil.listOf((Object)"/rulesets/basic.xml", (Object[])new String[0]));
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"/rulesets/basic.xml", (Object[])new String[0]), (Object)configuration.getRuleSetPaths());
        configuration.addRuleSet("foo.xml");
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"/rulesets/basic.xml", (Object[])new String[]{"foo.xml"}), (Object)configuration.getRuleSetPaths());
        configuration.setRuleSets(Collections.emptyList());
        MatcherAssert.assertThat((Object)configuration.getRuleSetPaths(), (Matcher)Matchers.empty());
        configuration.addRuleSet("foo.xml");
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"foo.xml", (Object[])new String[0]), (Object)configuration.getRuleSetPaths());
    }

    @Test
    void testMinimumPriority() {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertEquals((Object)RulePriority.LOW, (Object)configuration.getMinimumPriority(), (String)"Default minimum priority");
        configuration.setMinimumPriority(RulePriority.HIGH);
        Assertions.assertEquals((Object)RulePriority.HIGH, (Object)configuration.getMinimumPriority(), (String)"Changed minimum priority");
    }

    @Test
    void testSourceEncoding() {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertEquals((Object)System.getProperty("file.encoding"), (Object)configuration.getSourceEncoding().name(), (String)"Default source encoding");
        configuration.setSourceEncoding(StandardCharsets.UTF_16LE);
        Assertions.assertEquals((Object)StandardCharsets.UTF_16LE, (Object)configuration.getSourceEncoding(), (String)"Changed source encoding");
    }

    @Test
    void testReportFormat() {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertEquals(null, (Object)configuration.getReportFormat(), (String)"Default report format");
        configuration.setReportFormat("csv");
        Assertions.assertEquals((Object)"csv", (Object)configuration.getReportFormat(), (String)"Changed report format");
    }

    @Test
    void testCreateRenderer() {
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.setReportFormat("csv");
        Renderer renderer = configuration.createRenderer();
        Assertions.assertEquals(CSVRenderer.class, renderer.getClass(), (String)"Renderer class");
        Assertions.assertEquals((Object)false, (Object)renderer.isShowSuppressedViolations(), (String)"Default renderer show suppressed violations");
        configuration.setShowSuppressedViolations(true);
        renderer = configuration.createRenderer();
        Assertions.assertEquals(CSVRenderer.class, renderer.getClass(), (String)"Renderer class");
        Assertions.assertEquals((Object)true, (Object)renderer.isShowSuppressedViolations(), (String)"Changed renderer show suppressed violations");
    }

    @Test
    void testShowSuppressedViolations() {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertEquals((Object)false, (Object)configuration.isShowSuppressedViolations(), (String)"Default show suppressed violations");
        configuration.setShowSuppressedViolations(true);
        Assertions.assertEquals((Object)true, (Object)configuration.isShowSuppressedViolations(), (String)"Changed show suppressed violations");
    }

    @Test
    void testReportProperties() {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertEquals((int)0, (int)configuration.getReportProperties().size(), (String)"Default report properties size");
        configuration.getReportProperties().put("key", "value");
        Assertions.assertEquals((int)1, (int)configuration.getReportProperties().size(), (String)"Changed report properties size");
        Assertions.assertEquals((Object)"value", (Object)configuration.getReportProperties().get("key"), (String)"Changed report properties value");
        configuration.setReportProperties(new Properties());
        Assertions.assertEquals((int)0, (int)configuration.getReportProperties().size(), (String)"Replaced report properties size");
    }

    @Test
    void testAnalysisCache(@TempDir Path folder) throws IOException {
        PMDConfiguration configuration = new PMDConfiguration();
        Assertions.assertNotNull((Object)configuration.getAnalysisCache(), (String)"Default cache is null");
        Assertions.assertTrue((boolean)(configuration.getAnalysisCache() instanceof NoopAnalysisCache), (String)"Default cache is not a noop");
        configuration.setAnalysisCache(null);
        Assertions.assertNotNull((Object)configuration.getAnalysisCache(), (String)"Default cache was set to null");
        File cacheFile = folder.resolve("pmd-cachefile").toFile();
        Assertions.assertTrue((boolean)cacheFile.createNewFile());
        FileAnalysisCache analysisCache = new FileAnalysisCache(cacheFile);
        configuration.setAnalysisCache((AnalysisCache)analysisCache);
        Assertions.assertSame((Object)analysisCache, (Object)configuration.getAnalysisCache(), (String)"Configured cache not stored");
    }

    @Test
    void testAnalysisCacheLocation() {
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.setAnalysisCacheLocation(null);
        Assertions.assertNotNull((Object)configuration.getAnalysisCache(), (String)"Null cache location accepted");
        Assertions.assertTrue((boolean)(configuration.getAnalysisCache() instanceof NoopAnalysisCache), (String)"Null cache location accepted");
        configuration.setAnalysisCacheLocation("pmd.cache");
        Assertions.assertNotNull((Object)configuration.getAnalysisCache(), (String)"Not null cache location produces null cache");
        Assertions.assertTrue((boolean)(configuration.getAnalysisCache() instanceof FileAnalysisCache), (String)"File cache location doesn't produce a file cache");
    }

    @Test
    void testIgnoreIncrementalAnalysis(@TempDir Path folder) throws IOException {
        PMDConfiguration configuration = new PMDConfiguration();
        File cacheFile = folder.resolve("pmd-cachefile").toFile();
        Assertions.assertTrue((boolean)cacheFile.createNewFile());
        FileAnalysisCache analysisCache = new FileAnalysisCache(cacheFile);
        configuration.setAnalysisCache((AnalysisCache)analysisCache);
        Assertions.assertNotNull((Object)configuration.getAnalysisCache(), (String)"Null cache location accepted");
        Assertions.assertFalse((boolean)(configuration.getAnalysisCache() instanceof NoopAnalysisCache), (String)"Non null cache location, cache should not be noop");
        configuration.setIgnoreIncrementalAnalysis(true);
        Assertions.assertTrue((boolean)(configuration.getAnalysisCache() instanceof NoopAnalysisCache), (String)"Ignoring incremental analysis should turn the cache into a noop");
    }
}

