/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.nio.file.Paths;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.lang.Dummy2LanguageModule;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.SimpleTestTextFile;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ReportStats;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PmdAnalysisTest {
    PmdAnalysisTest() {
    }

    @Test
    void testPmdAnalysisWithEmptyConfig() {
        PMDConfiguration config = new PMDConfiguration();
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            MatcherAssert.assertThat((Object)pmd.files().getCollectedFiles(), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)pmd.rulesets(), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)pmd.renderers(), (Matcher)Matchers.empty());
        }
    }

    @Test
    void testRendererInteractions() throws IOException {
        PMDConfiguration config = new PMDConfiguration();
        config.addInputPath(Paths.get("sample-source/dummy", new String[0]));
        Renderer renderer = (Renderer)Mockito.spy(Renderer.class);
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.addRenderer(renderer);
            ((Renderer)Mockito.verify((Object)renderer, (VerificationMode)Mockito.never())).start();
            pmd.performAnalysis();
        }
        ((Renderer)Mockito.verify((Object)renderer, (VerificationMode)Mockito.times((int)1))).renderFileReport((Report)ArgumentMatchers.any());
        ((Renderer)Mockito.verify((Object)renderer, (VerificationMode)Mockito.times((int)1))).start();
        ((Renderer)Mockito.verify((Object)renderer, (VerificationMode)Mockito.times((int)1))).end();
        ((Renderer)Mockito.verify((Object)renderer, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    void testRulesetLoading() {
        PMDConfiguration config = new PMDConfiguration();
        config.addRuleSet("rulesets/dummy/basic.xml");
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            MatcherAssert.assertThat((Object)pmd.rulesets(), (Matcher)Matchers.hasSize((int)1));
        }
    }

    @Test
    void testRulesetWhenSomeoneHasAnError() {
        PMDConfiguration config = new PMDConfiguration();
        config.addRuleSet("rulesets/dummy/basic.xml");
        config.addRuleSet("rulesets/xxxe/notaruleset.xml");
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            MatcherAssert.assertThat((Object)pmd.rulesets(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)pmd.getReporter().numErrors(), (Matcher)Matchers.equalTo((Object)1));
        }
    }

    @Test
    void testParseException() {
        PMDConfiguration config = new PMDConfiguration();
        config.setThreads(1);
        config.setForceLanguageVersion(DummyLanguageModule.getInstance().getVersionWhereParserThrows());
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)new MockRule()));
            pmd.files().addSourceFile(FileId.fromPathLikeString((String)"file"), "some source");
            ReportStats stats = pmd.runAndReturnStats();
            Assertions.assertEquals((int)1, (int)stats.getNumErrors(), (String)"Errors");
            Assertions.assertEquals((int)0, (int)stats.getNumViolations(), (String)"Violations");
        }
    }

    @Test
    void testRuleFailureDuringInitialization() {
        PMDConfiguration config = new PMDConfiguration();
        config.setThreads(1);
        PmdReporter mockReporter = (PmdReporter)Mockito.spy((Object)PmdReporter.quiet());
        config.setReporter(mockReporter);
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)new MockRule(){

                public void initialize(LanguageProcessor languageProcessor) {
                    throw new IllegalStateException();
                }
            }));
            pmd.files().addSourceFile(FileId.fromPathLikeString((String)"fname1.dummy"), "some source");
            ReportStats stats = pmd.runAndReturnStats();
            Assertions.assertEquals((int)0, (int)stats.getNumErrors(), (String)"Errors");
            Assertions.assertEquals((int)0, (int)stats.getNumViolations(), (String)"Violations");
            ((PmdReporter)Mockito.verify((Object)mockReporter)).errorEx(Mockito.contains((String)"init"), (Throwable)ArgumentMatchers.any(IllegalStateException.class));
        }
    }

    @Test
    void testFileWithSpecificLanguage() {
        Dummy2LanguageModule language = Dummy2LanguageModule.getInstance();
        PMDConfiguration config = new PMDConfiguration();
        config.setIgnoreIncrementalAnalysis(true);
        RuleSet ruleset = RuleSet.forSingleRule((Rule)new TestRule());
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.addRuleSet(ruleset);
            pmd.files().addFile(Paths.get("src", "test", "resources", "sample-source", "dummy", "foo.txt"), (Language)language);
            Report report = pmd.performAnalysisAndCollectReport();
            for (Report.ProcessingError error : report.getProcessingErrors()) {
                System.out.println("error = " + error.getMsg() + ": " + error.getDetail());
            }
            Assertions.assertEquals((int)0, (int)report.getProcessingErrors().size());
            Assertions.assertEquals((int)1, (int)report.getViolations().size());
        }
    }

    @Test
    void testTextFileWithSpecificLanguage() {
        Dummy2LanguageModule language = Dummy2LanguageModule.getInstance();
        PMDConfiguration config = new PMDConfiguration();
        config.setIgnoreIncrementalAnalysis(true);
        RuleSet ruleset = RuleSet.forSingleRule((Rule)new TestRule());
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.addRuleSet(ruleset);
            pmd.files().addFile((TextFile)new SimpleTestTextFile("test content foo", FileId.fromPathLikeString((String)"foo.txt"), language.getDefaultVersion()));
            Report report = pmd.performAnalysisAndCollectReport();
            for (Report.ProcessingError error : report.getProcessingErrors()) {
                System.out.println("error = " + error.getMsg() + ": " + error.getDetail());
            }
            Assertions.assertEquals((int)0, (int)report.getProcessingErrors().size());
            Assertions.assertEquals((int)1, (int)report.getViolations().size());
        }
    }

    private static class TestRule
    extends AbstractRule {
        TestRule() {
            this.setLanguage((Language)Dummy2LanguageModule.getInstance());
            this.setMessage("dummy 2 test rule");
        }

        public void apply(Node node, RuleContext ctx) {
            ctx.addViolation(node);
        }
    }
}

