/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageFilenameFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileSelectorTest {
    FileSelectorTest() {
    }

    @Test
    void testWantedFile() {
        LanguageFilenameFilter fileSelector = new LanguageFilenameFilter((Language)DummyLanguageModule.getInstance());
        File javaFile = new File("/path/to/myFile.dummy");
        boolean selected = fileSelector.accept(javaFile.getParentFile(), javaFile.getName());
        Assertions.assertTrue((boolean)selected, (String)"This file should be selected !");
    }

    @Test
    void testUnwantedFile() {
        LanguageFilenameFilter fileSelector = new LanguageFilenameFilter((Language)DummyLanguageModule.getInstance());
        File javaFile = new File("/path/to/myFile.notdummy");
        boolean selected = fileSelector.accept(javaFile.getParentFile(), javaFile.getName());
        Assertions.assertFalse((boolean)selected, (String)"Not-source file must not be selected!");
    }

    @Test
    void testUnwantedJavaFile() {
        LanguageFilenameFilter fileSelector = new LanguageFilenameFilter((Language)DummyLanguageModule.getInstance());
        File javaFile = new File("/path/to/MyClass.java");
        boolean selected = fileSelector.accept(javaFile.getParentFile(), javaFile.getName());
        Assertions.assertFalse((boolean)selected, (String)"Unwanted java file must not be selected!");
    }
}

