/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.Collections;
import java.util.regex.Pattern;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.InternalApiBridge;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ReportTestUtil;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AbstractRuleTest {
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();

    AbstractRuleTest() {
    }

    @Test
    void testCreateRV() {
        MyRule r = new MyRule();
        r.setRuleSetName("foo");
        DummyNode.DummyRootNode s = this.helper.parse("abc()", FileId.fromPathLikeString((String)"abc"));
        InternalApiBridge.createRuleContext(rv -> {
            Assertions.assertEquals((int)1, (int)rv.getBeginLine(), (String)"Line number mismatch!");
            Assertions.assertEquals((Object)"abc", (Object)rv.getFileId().getOriginalPath(), (String)"Filename mismatch!");
            Assertions.assertEquals((Object)((Object)r), (Object)rv.getRule(), (String)"Rule object mismatch!");
            Assertions.assertEquals((Object)"my rule msg", (Object)rv.getDescription(), (String)"Rule msg mismatch!");
            Assertions.assertEquals((Object)"foo", (Object)rv.getRule().getRuleSetName(), (String)"RuleSet name mismatch!");
        }, (Rule)r).addViolation((Node)s);
    }

    @Test
    void testCreateRV2() {
        MyRule r = new MyRule();
        DummyNode.DummyRootNode s = this.helper.parse("abc()", FileId.fromPathLikeString((String)"filename"));
        InternalApiBridge.createRuleContext(rv -> {
            Assertions.assertEquals((int)1, (int)rv.getBeginLine(), (String)"Line number mismatch!");
            Assertions.assertEquals((Object)"filename", (Object)rv.getFileId().getOriginalPath(), (String)"Filename mismatch!");
            Assertions.assertEquals((Object)((Object)r), (Object)rv.getRule(), (String)"Rule object mismatch!");
            Assertions.assertEquals((Object)"specificdescription", (Object)rv.getDescription(), (String)"Rule description mismatch!");
        }, (Rule)r).addViolationWithMessage((Node)s, "specificdescription");
    }

    @Test
    void testRuleWithVariableInMessage() {
        MyRule r = new MyRule(){

            @Override
            public void apply(Node target, RuleContext ctx) {
                ctx.addViolation(target);
            }
        };
        r.definePropertyDescriptor(((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"testInt").desc("description")).require(NumericConstraints.inRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)))).defaultValue((Object)10)).build());
        r.setMessage("Message ${packageName} ${className} ${methodName} ${variableName} ${testInt} ${noSuchProperty}");
        DummyNode.DummyRootNode s = this.helper.parse("abc()", FileId.UNKNOWN);
        RuleViolation rv = (RuleViolation)ReportTestUtil.getReportForRuleApply((Rule)r, (Node)s).getViolations().get(0);
        Assertions.assertEquals((Object)"Message foo ${className} ${methodName} ${variableName} 10 ${noSuchProperty}", (Object)rv.getDescription());
    }

    @Test
    void testRuleSuppress() {
        DummyNode.DummyRootNode n = this.helper.parse("abc()", FileId.UNKNOWN).withNoPmdComments(Collections.singletonMap(1, "ohio"));
        FileAnalysisListener listener = (FileAnalysisListener)Mockito.mock(FileAnalysisListener.class);
        RuleContext ctx = InternalApiBridge.createRuleContext((FileAnalysisListener)listener, (Rule)new MyRule());
        ctx.addViolationWithMessage((Node)n, "message");
        ((FileAnalysisListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRuleViolation((RuleViolation)ArgumentMatchers.any());
        ((FileAnalysisListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onSuppressedRuleViolation((Report.SuppressedViolation)ArgumentMatchers.any());
    }

    @Test
    void testEquals1() {
        MyRule r = new MyRule();
        Assertions.assertFalse((boolean)r.equals(null), (String)"A rule is never equals to null!");
    }

    @Test
    void testEquals2() {
        MyRule r = new MyRule();
        Assertions.assertEquals((Object)((Object)r), (Object)((Object)r), (String)"A rule must be equals to itself");
    }

    @Test
    void testEquals3() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        Assertions.assertEquals((Object)((Object)r1), (Object)((Object)r2), (String)"Two instances of the same rule are equal");
        Assertions.assertEquals((int)r1.hashCode(), (int)r2.hashCode(), (String)"Hashcode for two instances of the same rule must be equal");
    }

    @Test
    void testEquals4() {
        MyRule myRule = new MyRule();
        Assertions.assertFalse((boolean)myRule.equals("MyRule"), (String)"A rule cannot be equal to an object of another class");
    }

    @Test
    void testEquals5() {
        MyRule myRule = new MyRule();
        MyOtherRule myOtherRule = new MyOtherRule();
        Assertions.assertFalse((boolean)myRule.equals((Object)myOtherRule), (String)"Two rules from different classes cannot be equal");
    }

    @Test
    void testEquals6() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        r2.setName("MyRule2");
        Assertions.assertFalse((boolean)r1.equals((Object)r2), (String)"Rules with different names cannot be equal");
    }

    @Test
    void testEquals7() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        r2.setPriority(RulePriority.HIGH);
        Assertions.assertFalse((boolean)r1.equals((Object)r2), (String)"Rules with different priority levels cannot be equal");
    }

    @Test
    void testEquals8() {
        MyRule r1 = new MyRule();
        r1.setProperty(MyRule.XPATH_PROPERTY, "something");
        MyRule r2 = new MyRule();
        r2.setProperty(MyRule.XPATH_PROPERTY, "something else");
        Assertions.assertFalse((boolean)r1.equals((Object)r2), (String)"Rules with different properties values cannot be equal");
    }

    @Test
    void testEquals9() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        r2.setProperty(MyRule.XPATH_PROPERTY, "something else");
        Assertions.assertFalse((boolean)r1.equals((Object)r2), (String)"Rules with different properties cannot be equal");
    }

    @Test
    void testEquals10() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        r2.setMessage("another message");
        Assertions.assertEquals((Object)((Object)r1), (Object)((Object)r2), (String)"Rules with different messages are still equal");
        Assertions.assertEquals((int)r1.hashCode(), (int)r2.hashCode(), (String)"Rules that are equal must have the an equal hashcode");
    }

    @Test
    void twoRulesUsingPatternPropertiesShouldBeEqual() {
        class MockRuleWithPatternProperty
        extends MockRule {
            MockRuleWithPatternProperty(String defaultValue) {
                this.definePropertyDescriptor(((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"myRegexProperty").desc("description")).defaultValue(defaultValue).build());
            }
        }
        Assertions.assertEquals((Object)((Object)new MockRuleWithPatternProperty("abc")), (Object)((Object)new MockRuleWithPatternProperty("abc")));
        Assertions.assertNotEquals((Object)((Object)new MockRuleWithPatternProperty("abc")), (Object)((Object)new MockRuleWithPatternProperty("def")));
        MockRuleWithPatternProperty rule1 = new MockRuleWithPatternProperty("abc");
        PropertyDescriptor myRegexProperty1 = rule1.getPropertyDescriptor("myRegexProperty");
        rule1.setProperty(myRegexProperty1, Pattern.compile("ghi"));
        MockRuleWithPatternProperty rule2 = new MockRuleWithPatternProperty("abc");
        PropertyDescriptor myRegexProperty2 = rule1.getPropertyDescriptor("myRegexProperty");
        rule2.setProperty(myRegexProperty2, Pattern.compile("ghi"));
        Assertions.assertEquals((Object)((Object)rule1), (Object)((Object)rule2));
        rule2.setProperty(myRegexProperty2, Pattern.compile("jkl"));
        Assertions.assertNotEquals((Object)((Object)rule1), (Object)((Object)rule2));
        Assertions.assertEquals((Object)((Object)new MockRuleWithPatternProperty("jkl")), (Object)((Object)rule2));
    }

    @Test
    void testDeepCopyRule() {
        MyRule r1 = new MyRule();
        MyRule r2 = (MyRule)r1.deepCopy();
        Assertions.assertEquals((Object)r1.getDescription(), (Object)r2.getDescription());
        Assertions.assertEquals((Object)r1.getExamples(), (Object)r2.getExamples());
        Assertions.assertEquals((Object)r1.getExternalInfoUrl(), (Object)r2.getExternalInfoUrl());
        Assertions.assertEquals((Object)r1.getLanguage(), (Object)r2.getLanguage());
        Assertions.assertEquals((Object)r1.getMaximumLanguageVersion(), (Object)r2.getMaximumLanguageVersion());
        Assertions.assertEquals((Object)r1.getMessage(), (Object)r2.getMessage());
        Assertions.assertEquals((Object)r1.getMinimumLanguageVersion(), (Object)r2.getMinimumLanguageVersion());
        Assertions.assertEquals((Object)r1.getName(), (Object)r2.getName());
        Assertions.assertEquals((Object)r1.getPriority(), (Object)r2.getPriority());
        Assertions.assertEquals((Object)r1.getPropertyDescriptors(), (Object)r2.getPropertyDescriptors());
        Assertions.assertEquals((Object)r1.getRuleClass(), (Object)r2.getRuleClass());
        Assertions.assertEquals((Object)r1.getRuleSetName(), (Object)r2.getRuleSetName());
        Assertions.assertEquals((Object)r1.getSince(), (Object)r2.getSince());
        Assertions.assertEquals((Object)r1.isPropertyOverridden(MyRule.FOO_DEFAULT_PROPERTY), (Object)r2.isPropertyOverridden(MyRule.FOO_DEFAULT_PROPERTY));
    }

    private static class MyOtherRule
    extends AbstractRule {
        private static final PropertyDescriptor<String> FOO_PROPERTY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"foo").desc("foo property")).defaultValue((Object)"x")).build();

        MyOtherRule() {
            this.definePropertyDescriptor(FOO_PROPERTY);
            this.setName("MyOtherRule");
            this.setMessage("my other rule");
            this.setPriority(RulePriority.MEDIUM);
            this.setProperty(FOO_PROPERTY, "value");
        }

        public void apply(Node target, RuleContext ctx) {
        }
    }

    private static class MyRule
    extends AbstractRule {
        private static final PropertyDescriptor<String> FOO_PROPERTY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"foo").desc("foo property")).defaultValue((Object)"x")).build();
        private static final PropertyDescriptor<String> FOO_DEFAULT_PROPERTY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"fooDefault").defaultValue((Object)"bar")).desc("Property without value uses default value")).build();
        private static final PropertyDescriptor<String> XPATH_PROPERTY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"xpath").desc("xpath property")).defaultValue((Object)"")).build();

        MyRule() {
            this.definePropertyDescriptor(FOO_PROPERTY);
            this.definePropertyDescriptor(XPATH_PROPERTY);
            this.definePropertyDescriptor(FOO_DEFAULT_PROPERTY);
            this.setName("MyRule");
            this.setMessage("my rule msg");
            this.setPriority(RulePriority.MEDIUM);
            this.setProperty(FOO_PROPERTY, "value");
        }

        public void apply(Node target, RuleContext ctx) {
        }
    }
}

