/*
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */

package net.sourceforge.pmd.lang.ast.impl.javacc;

import java.util.HashMap;
import java.util.Map;

import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.lang.TokenManager;

/**
 * A base class for the token managers generated by JavaCC.
 */
public abstract class AbstractTokenManager implements TokenManager<JavaccToken> {

    protected Map<Integer, String> suppressMap = new HashMap<>();
    protected String suppressMarker = PMDConfiguration.DEFAULT_SUPPRESS_MARKER;

    public void setSuppressMarker(String marker) {
        this.suppressMarker = marker;
    }

    public Map<Integer, String> getSuppressMap() {
        return suppressMap;
    }
}
