/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.commands.typesupport.internal;

import java.util.Iterator;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import picocli.CommandLine;

public class LanguageTypeSupport
implements CommandLine.ITypeConverter<Language>,
Iterable<String> {
    private final LanguageRegistry languageRegistry;

    public LanguageTypeSupport(LanguageRegistry languageRegistry) {
        this.languageRegistry = languageRegistry;
    }

    public Language convert(String value) {
        Language lang = this.languageRegistry.getLanguageById(value);
        if (lang == null) {
            throw new CommandLine.TypeConversionException("Unknown language: " + value);
        }
        return lang;
    }

    @Override
    public Iterator<String> iterator() {
        return this.languageRegistry.getLanguages().stream().map(Language::getId).iterator();
    }
}

