/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.commands.internal;

import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.pmd.cli.commands.internal.AbstractAnalysisPmdSubcommand;
import net.sourceforge.pmd.cli.commands.typesupport.internal.CpdLanguageTypeSupport;
import net.sourceforge.pmd.cli.internal.CliExitCode;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.internal.LogMessages;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.checkerframework.checker.nullness.qual.NonNull;
import picocli.CommandLine;

@CommandLine.Command(name="cpd", showDefaultValues=true, description={"Copy/Paste Detector - find duplicate code"})
public class CpdCommand
extends AbstractAnalysisPmdSubcommand<CPDConfiguration> {
    @CommandLine.ArgGroup(heading="Input files specification", exclusive=false)
    AbstractAnalysisPmdSubcommand.FileCollectionOptions<CPDConfiguration> files = new AbstractAnalysisPmdSubcommand.FileCollectionOptions();
    @CommandLine.Option(names={"--language", "-l"}, description={"The source code language.%nValid values: ${COMPLETION-CANDIDATES}"}, defaultValue="java", converter={CpdLanguageTypeSupport.class}, completionCandidates=CpdLanguageTypeSupport.class)
    private Language language;
    @CommandLine.Option(names={"--minimum-tokens"}, description={"The minimum token length which should be reported as a duplicate."}, required=true)
    private int minimumTokens;
    @CommandLine.Option(names={"--skip-duplicate-files"}, description={"Ignore multiple copies of files of the same name and length in comparison."})
    private boolean skipDuplicates;
    @CommandLine.Option(names={"--format", "-f"}, description={"Report format.%nValid values: ${COMPLETION-CANDIDATES}%nAlternatively, you can provide the fully qualified name of a custom CpdRenderer in the classpath."}, defaultValue="text", completionCandidates=CpdSupportedReportFormatsCandidates.class)
    private String rendererName;
    @CommandLine.Option(names={"--ignore-literals"}, description={"Ignore literal values such as numbers and strings when comparing text."})
    private boolean ignoreLiterals;
    @CommandLine.Option(names={"--ignore-identifiers"}, description={"Ignore names of classes, methods, variables, constants, etc. when comparing text."})
    private boolean ignoreIdentifiers;
    @CommandLine.Option(names={"--ignore-annotations"}, description={"Ignore language annotations when comparing text."})
    private boolean ignoreAnnotations;
    @CommandLine.Option(names={"--ignore-usings"}, description={"Ignore using directives in C#"})
    private boolean ignoreUsings;
    @CommandLine.Option(names={"--ignore-literal-sequences"}, description={"Ignore sequences of literals such as list initializers."})
    private boolean ignoreLiteralSequences;
    @CommandLine.Option(names={"--ignore-sequences"}, description={"Ignore sequences of identifiers and literals"})
    private boolean ignoreIdentifierAndLiteralSequences;
    @CommandLine.Option(names={"--skip-lexical-errors"}, description={"Skip files which can't be tokenized due to invalid characters, instead of aborting with an error. Deprecated - use --[no-]fail-on-error instead."})
    @Deprecated
    private boolean skipLexicalErrors;
    @CommandLine.Option(names={"--no-skip-blocks"}, description={"Do not skip code blocks marked with --skip-blocks-pattern (e.g. #if 0 until #endif)."})
    private boolean noSkipBlocks;
    @CommandLine.Option(names={"--skip-blocks-pattern"}, description={"Pattern to find the blocks to skip. Start and End pattern separated by |."}, defaultValue="#if 0|#endif")
    private String skipBlocksPattern;

    @Override
    protected AbstractAnalysisPmdSubcommand.FileCollectionOptions<CPDConfiguration> getFileCollectionOptions() {
        return this.files;
    }

    @Override
    protected CPDConfiguration toConfiguration() {
        CPDConfiguration configuration = new CPDConfiguration();
        this.setCommonConfigProperties(configuration);
        configuration.setIgnoreAnnotations(this.ignoreAnnotations);
        configuration.setIgnoreIdentifiers(this.ignoreIdentifiers);
        configuration.setIgnoreLiterals(this.ignoreLiterals);
        configuration.setIgnoreLiteralSequences(this.ignoreLiteralSequences);
        configuration.setIgnoreUsings(this.ignoreUsings);
        configuration.setOnlyRecognizeLanguage(this.language);
        configuration.setMinimumTileSize(this.minimumTokens);
        configuration.setNoSkipBlocks(this.noSkipBlocks);
        configuration.setRendererName(this.rendererName);
        configuration.setSkipBlocksPattern(this.skipBlocksPattern);
        configuration.setSkipDuplicates(this.skipDuplicates);
        if (this.skipLexicalErrors) {
            configuration.getReporter().warn("--skip-lexical-errors is deprecated. Use --no-fail-on-error instead.", new Object[0]);
            configuration.setFailOnError(false);
        }
        return configuration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected @NonNull CliExitCode doExecute(CPDConfiguration configuration) {
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)configuration);){
            boolean hasErrors;
            MutableBoolean hasViolations = new MutableBoolean();
            cpd.performAnalysis(report -> hasViolations.setValue(!report.getMatches().isEmpty()));
            boolean bl = hasErrors = configuration.getReporter().numErrors() > 0;
            if (hasErrors && configuration.isFailOnError()) {
                CliExitCode cliExitCode = CliExitCode.RECOVERED_ERRORS_OR_VIOLATIONS;
                return cliExitCode;
            }
            if (!hasViolations.booleanValue()) return CliExitCode.OK;
            if (!configuration.isFailOnViolation()) return CliExitCode.OK;
            CliExitCode cliExitCode = CliExitCode.VIOLATIONS_FOUND;
            return cliExitCode;
        }
        catch (IOException | RuntimeException e) {
            configuration.getReporter().errorEx("Exception while running CPD.", (Throwable)e);
            configuration.getReporter().info(StringUtil.quoteMessageFormat((String)LogMessages.errorDetectedMessage((int)1, (String)"cpd")), new Object[0]);
            return CliExitCode.ERROR;
        }
    }

    private static final class CpdSupportedReportFormatsCandidates
    implements Iterable<String> {
        private CpdSupportedReportFormatsCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            return CPDConfiguration.getRenderers().stream().sorted().iterator();
        }
    }
}

