/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApexXSSFromEscapeFalseRule
extends AbstractApexRule {
    private static final String ADD_ERROR = "addError";

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        for (ASTMethodCallExpression methodCall : node.descendants(ASTMethodCallExpression.class)) {
            if (!Helper.isMethodName(methodCall, ADD_ERROR)) continue;
            this.validateBooleanParameter(methodCall, data);
        }
        return data;
    }

    private void validateBooleanParameter(ASTMethodCallExpression methodCall, Object data) {
        boolean paramValue;
        ASTLiteralExpression parameter;
        Node potentialLiteral;
        int numberOfChildren = methodCall.getNumChildren();
        if (numberOfChildren == 3 && (potentialLiteral = methodCall.getChild(2)) instanceof ASTLiteralExpression && (parameter = (ASTLiteralExpression)potentialLiteral).isBoolean() && !(paramValue = Boolean.parseBoolean(parameter.getImage()))) {
            this.validateLiteralPresence(methodCall, data);
        }
    }

    private void validateLiteralPresence(ASTMethodCallExpression methodCall, Object data) {
        for (ASTVariableExpression v : methodCall.descendants(ASTVariableExpression.class)) {
            this.asCtx(data).addViolation((Node)v);
        }
    }
}

