/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTNewObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApexOpenRedirectRule
extends AbstractApexRule {
    private static final String PAGEREFERENCE = "PageReference";
    private final Set<String> listOfStringLiteralVariables = new HashSet<String>();

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        for (ASTAssignmentExpression assignment : node.descendants(ASTAssignmentExpression.class)) {
            this.findSafeLiterals(assignment);
        }
        for (ASTVariableDeclaration varDecl : node.descendants(ASTVariableDeclaration.class)) {
            this.findSafeLiterals(varDecl);
        }
        for (ASTField fDecl : node.descendants(ASTField.class)) {
            this.findSafeLiterals(fDecl);
        }
        for (ASTNewObjectExpression newObj : node.descendants(ASTNewObjectExpression.class)) {
            this.checkNewObjects(newObj, data);
        }
        this.listOfStringLiteralVariables.clear();
        return data;
    }

    private void findSafeLiterals(ApexNode<?> node) {
        ASTField field;
        ASTLiteralExpression literal;
        ASTBinaryExpression binaryExp = (ASTBinaryExpression)node.firstChild(ASTBinaryExpression.class);
        if (binaryExp != null) {
            this.findSafeLiterals(binaryExp);
        }
        if ((literal = (ASTLiteralExpression)node.firstChild(ASTLiteralExpression.class)) != null) {
            int index = literal.getIndexInParent();
            if (index == 0) {
                if (node instanceof ASTVariableDeclaration) {
                    this.addVariable((ASTVariableDeclaration)node);
                } else if (node instanceof ASTBinaryExpression) {
                    ASTVariableExpression var;
                    ASTAssignmentExpression assignment;
                    ASTVariableDeclaration parent = (ASTVariableDeclaration)node.ancestors(ASTVariableDeclaration.class).first();
                    if (parent != null) {
                        this.addVariable(parent);
                    }
                    if ((assignment = (ASTAssignmentExpression)node.ancestors(ASTAssignmentExpression.class).first()) != null && (var = (ASTVariableExpression)assignment.firstChild(ASTVariableExpression.class)) != null) {
                        this.addVariable(var);
                    }
                }
            }
        } else if (node instanceof ASTField && "String".equalsIgnoreCase((field = (ASTField)node).getType()) && field.getValue() != null) {
            this.listOfStringLiteralVariables.add(Helper.getFQVariableName(field));
        }
    }

    private void addVariable(ASTVariableDeclaration node) {
        ASTVariableExpression variable = (ASTVariableExpression)node.firstChild(ASTVariableExpression.class);
        this.addVariable(variable);
    }

    private void addVariable(ASTVariableExpression node) {
        if (node != null) {
            this.listOfStringLiteralVariables.add(Helper.getFQVariableName(node));
        }
    }

    private void checkNewObjects(ASTNewObjectExpression node, Object data) {
        ASTMethod method = (ASTMethod)node.ancestors(ASTMethod.class).first();
        if (method != null && Helper.isTestMethodOrClass(method)) {
            return;
        }
        if (PAGEREFERENCE.equalsIgnoreCase(node.getType())) {
            this.getObjectValue(node, data);
        }
    }

    private void getObjectValue(ApexNode<?> node, Object data) {
        for (ASTVariableExpression variable : node.children(ASTVariableExpression.class)) {
            if (variable.getIndexInParent() != 0 || this.listOfStringLiteralVariables.contains(Helper.getFQVariableName(variable))) continue;
            this.asCtx(data).addViolation((Node)variable);
        }
        for (ASTBinaryExpression z : node.children(ASTBinaryExpression.class)) {
            this.getObjectValue(z, data);
        }
    }
}

