/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;

public class ApexInsecureEndpointRule
extends AbstractApexRule {
    private static final String SET_ENDPOINT = "setEndpoint";
    private static final Pattern PATTERN = Pattern.compile("^http://.+?$", 2);
    private final Set<String> httpEndpointStrings = new HashSet<String>();

    @Override
    public Object visit(ASTAssignmentExpression node, Object data) {
        this.findInsecureEndpoints(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        this.findInsecureEndpoints(node);
        return data;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        this.findInsecureEndpoints(node);
        return data;
    }

    private void findInsecureEndpoints(ApexNode<?> node) {
        ASTVariableExpression variableNode = (ASTVariableExpression)node.firstChild(ASTVariableExpression.class);
        this.findInnerInsecureEndpoints(node, variableNode);
        ASTBinaryExpression binaryNode = (ASTBinaryExpression)node.firstChild(ASTBinaryExpression.class);
        if (binaryNode != null) {
            this.findInnerInsecureEndpoints(binaryNode, variableNode);
        }
    }

    private void findInnerInsecureEndpoints(ApexNode<?> node, ASTVariableExpression variableNode) {
        String literal;
        ASTLiteralExpression literalNode = (ASTLiteralExpression)node.firstChild(ASTLiteralExpression.class);
        if (literalNode != null && variableNode != null && literalNode.isString() && PATTERN.matcher(literal = literalNode.getImage()).matches()) {
            this.httpEndpointStrings.add(Helper.getFQVariableName(variableNode));
        }
    }

    @Override
    public Object visit(ASTMethodCallExpression node, Object data) {
        this.processInsecureEndpoint(node, data);
        return data;
    }

    private void processInsecureEndpoint(ASTMethodCallExpression node, Object data) {
        if (!Helper.isMethodName(node, SET_ENDPOINT)) {
            return;
        }
        ASTBinaryExpression binaryNode = (ASTBinaryExpression)node.firstChild(ASTBinaryExpression.class);
        if (binaryNode != null) {
            this.runChecks(binaryNode, data);
        }
        this.runChecks(node, data);
    }

    private void runChecks(ApexNode<?> node, Object data) {
        ASTVariableExpression variableNode;
        String literal;
        ASTLiteralExpression literalNode = (ASTLiteralExpression)node.firstChild(ASTLiteralExpression.class);
        if (literalNode != null && literalNode.isString() && PATTERN.matcher(literal = literalNode.getImage()).matches()) {
            this.asCtx(data).addViolation((Node)literalNode);
        }
        if ((variableNode = (ASTVariableExpression)node.firstChild(ASTVariableExpression.class)) != null && this.httpEndpointStrings.contains(Helper.getFQVariableName(variableNode))) {
            this.asCtx(data).addViolation((Node)variableNode);
        }
    }
}

