/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import com.google.common.reflect.ClassPath;
import com.nawforce.runforce.Schema.SObjectType;
import com.nawforce.runforce.System.System;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TypeShadowsBuiltInNamespaceRule
extends AbstractRule {
    private static final ApexVisitor<RuleContext, Void> VISITOR = new Visitor();

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[]{ASTUserEnum.class, ASTUserInterface.class});
    }

    public void apply(Node target, RuleContext ctx) {
        target.acceptVisitor(VISITOR, (Object)ctx);
    }

    private static final class Visitor
    implements ApexVisitor<RuleContext, Void> {
        private final Set<String> systemTypes;
        private final Set<String> schemaTypes;

        private Visitor() {
            try {
                String systemPackageName = System.class.getPackage().getName();
                this.systemTypes = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getTopLevelClasses(systemPackageName).stream().map(ClassPath.ClassInfo::getSimpleName).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
                String schemaPackageName = SObjectType.class.getPackage().getName();
                this.schemaTypes = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getTopLevelClasses(schemaPackageName).stream().map(ClassPath.ClassInfo::getSimpleName).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void checkNode(ApexNode<?> node, RuleContext ruleContext) {
            String definingType = node.getDefiningType();
            if (definingType == null) {
                return;
            }
            if (this.systemTypes.contains(definingType.toLowerCase(Locale.ROOT))) {
                ruleContext.addViolation(node, new Object[]{"System"});
            }
            if (this.schemaTypes.contains(definingType.toLowerCase(Locale.ROOT))) {
                ruleContext.addViolation(node, new Object[]{"Schema"});
            }
        }

        @Override
        public Void visit(ASTUserClass node, RuleContext data) {
            this.checkNode(node, data);
            return null;
        }

        @Override
        public Void visit(ASTUserEnum node, RuleContext data) {
            this.checkNode(node, data);
            return null;
        }

        @Override
        public Void visit(ASTUserInterface node, RuleContext data) {
            this.checkNode(node, data);
            return null;
        }

        public Void visitNode(Node node, RuleContext param) {
            return null;
        }
    }
}

