/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.documentation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTFormalComment;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApexDocRule
extends AbstractApexRule {
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("@description\\s");
    private static final Pattern RETURN_PATTERN = Pattern.compile("@return\\s");
    private static final Pattern PARAM_PATTERN = Pattern.compile("@param\\s+(\\w+)\\s");
    private static final String MISSING_COMMENT_MESSAGE = "Missing ApexDoc comment";
    private static final String MISSING_DESCRIPTION_MESSAGE = "Missing ApexDoc @description";
    private static final String MISSING_RETURN_MESSAGE = "Missing ApexDoc @return";
    private static final String UNEXPECTED_RETURN_MESSAGE = "Unexpected ApexDoc @return";
    private static final String MISMATCHED_PARAM_MESSAGE = "Missing or mismatched ApexDoc @param";
    private static final PropertyDescriptor<Boolean> REPORT_PRIVATE_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"reportPrivate").desc("Report private classes, methods and properties")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> REPORT_PROTECTED_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"reportProtected").desc("Report protected classes, methods and properties")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> REPORT_MISSING_DESCRIPTION_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"reportMissingDescription").desc("Report missing @description")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<Boolean> REPORT_PROPERTY_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"reportProperty").desc("Report properties without comments")).defaultValue((Object)true)).build();

    public ApexDocRule() {
        this.definePropertyDescriptor(REPORT_PRIVATE_DESCRIPTOR);
        this.definePropertyDescriptor(REPORT_PROTECTED_DESCRIPTOR);
        this.definePropertyDescriptor(REPORT_MISSING_DESCRIPTION_DESCRIPTOR);
        this.definePropertyDescriptor(REPORT_PROPERTY_DESCRIPTOR);
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[]{ASTUserInterface.class, ASTMethod.class, ASTProperty.class});
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        this.handleClassOrInterface(node, data);
        return data;
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        this.handleClassOrInterface(node, data);
        return data;
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (node.getParent() instanceof ASTProperty) {
            return data;
        }
        ApexDocComment comment = this.getApexDocComment(node);
        if (comment == null) {
            if (this.shouldHaveApexDocs(node)) {
                this.asCtx(data).addViolationWithMessage((Node)node, MISSING_COMMENT_MESSAGE);
            }
        } else {
            List params;
            String returnType;
            boolean shouldHaveReturn;
            if (((Boolean)this.getProperty(REPORT_MISSING_DESCRIPTION_DESCRIPTOR)).booleanValue() && !comment.hasDescription) {
                this.asCtx(data).addViolationWithMessage((Node)node, MISSING_DESCRIPTION_MESSAGE);
            }
            boolean bl = shouldHaveReturn = !(returnType = node.getReturnType()).isEmpty() && !"void".equalsIgnoreCase(returnType);
            if (comment.hasReturn != shouldHaveReturn) {
                if (shouldHaveReturn) {
                    this.asCtx(data).addViolationWithMessage((Node)node, MISSING_RETURN_MESSAGE);
                } else {
                    this.asCtx(data).addViolationWithMessage((Node)node, UNEXPECTED_RETURN_MESSAGE);
                }
            }
            if (!comment.params.equals(params = node.children(ASTParameter.class).toStream().map(ASTParameter::getImage).collect(Collectors.toList()))) {
                this.asCtx(data).addViolationWithMessage((Node)node, MISMATCHED_PARAM_MESSAGE);
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTProperty node, Object data) {
        ApexDocComment comment = this.getApexDocComment(node);
        if (comment == null) {
            if (this.shouldHaveApexDocs(node)) {
                this.asCtx(data).addViolationWithMessage((Node)node, MISSING_COMMENT_MESSAGE);
            }
        } else if (((Boolean)this.getProperty(REPORT_MISSING_DESCRIPTION_DESCRIPTOR)).booleanValue() && !comment.hasDescription) {
            this.asCtx(data).addViolationWithMessage((Node)node, MISSING_DESCRIPTION_MESSAGE);
        }
        return data;
    }

    private void handleClassOrInterface(ApexNode<?> node, Object data) {
        ApexDocComment comment = this.getApexDocComment(node);
        if (comment == null) {
            if (this.shouldHaveApexDocs(node)) {
                this.asCtx(data).addViolationWithMessage(node, MISSING_COMMENT_MESSAGE);
            }
        } else if (((Boolean)this.getProperty(REPORT_MISSING_DESCRIPTION_DESCRIPTOR)).booleanValue() && !comment.hasDescription) {
            this.asCtx(data).addViolationWithMessage(node, MISSING_DESCRIPTION_MESSAGE);
        }
    }

    private boolean shouldHaveApexDocs(ApexNode<?> node) {
        if (!node.hasRealLoc()) {
            return false;
        }
        for (ASTAnnotation annotation : node.descendants(ASTAnnotation.class)) {
            if (!"IsTest".equalsIgnoreCase(annotation.getName())) continue;
            return false;
        }
        if (node instanceof ASTProperty && !((Boolean)this.getProperty(REPORT_PROPERTY_DESCRIPTOR)).booleanValue()) {
            return false;
        }
        ASTModifierNode modifier = (ASTModifierNode)node.firstChild(ASTModifierNode.class);
        if (modifier != null) {
            boolean flagPrivate = (Boolean)this.getProperty(REPORT_PRIVATE_DESCRIPTOR) != false && modifier.isPrivate();
            boolean flagProtected = (Boolean)this.getProperty(REPORT_PROTECTED_DESCRIPTOR) != false && modifier.isProtected();
            return (modifier.isPublic() || modifier.isGlobal() || flagPrivate || flagProtected) && !modifier.isOverride();
        }
        return false;
    }

    private ApexDocComment getApexDocComment(ApexNode<?> node) {
        ASTFormalComment comment = (ASTFormalComment)node.firstChild(ASTFormalComment.class);
        if (comment != null) {
            String token = comment.getImage();
            boolean hasDescription = DESCRIPTION_PATTERN.matcher(token).find();
            boolean hasReturn = RETURN_PATTERN.matcher(token).find();
            ArrayList<String> params = new ArrayList<String>();
            Matcher paramMatcher = PARAM_PATTERN.matcher(token);
            while (paramMatcher.find()) {
                params.add(paramMatcher.group(1));
            }
            return new ApexDocComment(hasDescription, hasReturn, params);
        }
        return null;
    }

    private static class ApexDocComment {
        boolean hasDescription;
        boolean hasReturn;
        List<String> params;

        ApexDocComment(boolean hasDescription, boolean hasReturn, List<String> params) {
            this.hasDescription = hasDescription;
            this.hasReturn = hasReturn;
            this.params = params;
        }
    }
}

