/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.rule.codestyle.AbstractNamingConventionsRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PropertyNamingConventionsRule
extends AbstractNamingConventionsRule {
    private static final Map<String, String> DESCRIPTOR_TO_DISPLAY_NAME = new HashMap<String, String>();
    private static final PropertyDescriptor<Pattern> STATIC_REGEX = ((PropertyBuilder.RegexPropertyBuilder)PropertyNamingConventionsRule.prop("staticPattern", "static property", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();
    private static final PropertyDescriptor<Pattern> INSTANCE_REGEX = ((PropertyBuilder.RegexPropertyBuilder)PropertyNamingConventionsRule.prop("instancePattern", "instance property", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();

    public PropertyNamingConventionsRule() {
        this.definePropertyDescriptor(STATIC_REGEX);
        this.definePropertyDescriptor(INSTANCE_REGEX);
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTField.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTField node, Object data) {
        if (node.ancestors(ASTProperty.class).first() == null) {
            return data;
        }
        if (node.getModifiers().isStatic()) {
            this.checkMatches(STATIC_REGEX, node, data);
        } else {
            this.checkMatches(INSTANCE_REGEX, node, data);
        }
        return data;
    }

    @Override
    protected String displayName(String name) {
        return DESCRIPTOR_TO_DISPLAY_NAME.get(name);
    }
}

