/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.rule.codestyle.AbstractNamingConventionsRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MethodNamingConventionsRule
extends AbstractNamingConventionsRule {
    private static final Map<String, String> DESCRIPTOR_TO_DISPLAY_NAME = new HashMap<String, String>();
    private static final PropertyDescriptor<Pattern> TEST_REGEX = ((PropertyBuilder.RegexPropertyBuilder)MethodNamingConventionsRule.prop("testPattern", "test method", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();
    private static final PropertyDescriptor<Pattern> STATIC_REGEX = ((PropertyBuilder.RegexPropertyBuilder)MethodNamingConventionsRule.prop("staticPattern", "static method", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();
    private static final PropertyDescriptor<Pattern> INSTANCE_REGEX = ((PropertyBuilder.RegexPropertyBuilder)MethodNamingConventionsRule.prop("instancePattern", "instance method", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();

    public MethodNamingConventionsRule() {
        this.definePropertyDescriptor(TEST_REGEX);
        this.definePropertyDescriptor(STATIC_REGEX);
        this.definePropertyDescriptor(INSTANCE_REGEX);
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTMethod.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (this.isOverriddenMethod(node) || this.isPropertyAccessor(node) || this.isConstructor(node)) {
            return data;
        }
        if (node.isStaticInitializer()) {
            return data;
        }
        if (node.ancestors(ASTUserEnum.class).first() != null) {
            return data;
        }
        if (node.getModifiers().isTest()) {
            this.checkMatches(TEST_REGEX, node, data);
        } else if (node.getModifiers().isStatic()) {
            this.checkMatches(STATIC_REGEX, node, data);
        } else {
            this.checkMatches(INSTANCE_REGEX, node, data);
        }
        return data;
    }

    @Override
    protected String displayName(String name) {
        return DESCRIPTOR_TO_DISPLAY_NAME.get(name);
    }

    private boolean isOverriddenMethod(ASTMethod node) {
        return node.getModifiers().isOverride();
    }

    private boolean isPropertyAccessor(ASTMethod node) {
        return node.ancestors(ASTProperty.class).nonEmpty();
    }

    private boolean isConstructor(ASTMethod node) {
        return node.isConstructor();
    }
}

