/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.declaration.TriggerDeclaration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public enum TriggerUsage {
    AFTER_DELETE(TriggerDeclaration.TriggerCase.TRIGGER_AFTER_DELETE),
    AFTER_INSERT(TriggerDeclaration.TriggerCase.TRIGGER_AFTER_INSERT),
    AFTER_UNDELETE(TriggerDeclaration.TriggerCase.TRIGGER_AFTER_UNDELETE),
    AFTER_UPDATE(TriggerDeclaration.TriggerCase.TRIGGER_AFTER_UPDATE),
    BEFORE_DELETE(TriggerDeclaration.TriggerCase.TRIGGER_BEFORE_DELETE),
    BEFORE_INSERT(TriggerDeclaration.TriggerCase.TRIGGER_BEFORE_INSERT),
    BEFORE_UNDELETE(TriggerDeclaration.TriggerCase.TRIGGER_BEFORE_UNDELETE),
    BEFORE_UPDATE(TriggerDeclaration.TriggerCase.TRIGGER_BEFORE_UPDATE);

    private final TriggerDeclaration.TriggerCase triggerCase;
    private static final Map<TriggerDeclaration.TriggerCase, TriggerUsage> APEX_TO_PMD;

    private TriggerUsage(TriggerDeclaration.TriggerCase triggerCase) {
        this.triggerCase = triggerCase;
    }

    private TriggerDeclaration.TriggerCase getTriggerCase() {
        return this.triggerCase;
    }

    public static TriggerUsage of(TriggerDeclaration.TriggerCase triggerCase) {
        TriggerUsage result = APEX_TO_PMD.get(triggerCase);
        if (result != null) {
            return result;
        }
        throw new NoSuchElementException("Unknown TriggerUsage value '" + triggerCase.name() + "'");
    }

    static {
        APEX_TO_PMD = new HashMap<TriggerDeclaration.TriggerCase, TriggerUsage>();
        for (TriggerUsage triggerUsage : TriggerUsage.values()) {
            APEX_TO_PMD.put(triggerUsage.getTriggerCase(), triggerUsage);
        }
    }
}

