/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.expression.UnaryExpression;

public enum PrefixOperator {
    POSITIVE("+"),
    NEGATIVE("-"),
    LOGICAL_NOT("!"),
    BITWISE_NOT("~"),
    INCREMENT("++"),
    DECREMENT("--");

    private final String symbol;

    private PrefixOperator(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static PrefixOperator valueOf(UnaryExpression.Operator op) {
        switch (op) {
            case PLUS: {
                return POSITIVE;
            }
            case NEGATION: {
                return NEGATIVE;
            }
            case LOGICAL_COMPLEMENT: {
                return LOGICAL_NOT;
            }
            case BITWISE_NOT: {
                return BITWISE_NOT;
            }
            case PRE_INCREMENT: {
                return INCREMENT;
            }
            case PRE_DECREMENT: {
                return DECREMENT;
            }
        }
        throw new IllegalArgumentException("Invalid prefix operator " + op);
    }
}

