/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassOrInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserTrigger;

public final class ApexQualifiedName {
    private static final Pattern QUALIFIED_NAME_PATTERN = Pattern.compile("(?<class1>\\w+)(?:.(?<class2>\\w+))?(?:#(?<operation>\\w+\\(.*\\)))?");
    private final String[] classes;
    private final String operation;

    private ApexQualifiedName(String[] classes, String operation) {
        this.operation = operation;
        this.classes = classes;
    }

    public String getOperation() {
        return this.operation;
    }

    public String[] getClasses() {
        return Arrays.copyOf(this.classes, this.classes.length);
    }

    public boolean isClass() {
        return this.operation == null;
    }

    public boolean isOperation() {
        return this.operation != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.classes[0]);
        if (this.classes.length > 1) {
            sb.append('.').append(this.classes[1]);
        }
        if (this.isOperation()) {
            sb.append("#").append(this.operation);
        }
        return sb.toString();
    }

    public ApexQualifiedName getClassName() {
        if (this.isClass()) {
            return this;
        }
        return new ApexQualifiedName(this.classes, null);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.classes);
        result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof ApexQualifiedName && Objects.deepEquals(this.classes, ((ApexQualifiedName)obj).classes) && Objects.equals(this.operation, ((ApexQualifiedName)obj).operation);
    }

    public static ApexQualifiedName ofString(String toParse) {
        Matcher matcher = QUALIFIED_NAME_PATTERN.matcher(toParse);
        if (matcher.matches()) {
            ArrayList<String> classNames = new ArrayList<String>();
            classNames.add(matcher.group("class1"));
            if (matcher.group("class2") != null) {
                classNames.add(matcher.group("class2"));
            }
            return new ApexQualifiedName(classNames.toArray(new String[0]), matcher.group("operation"));
        }
        return null;
    }

    static ApexQualifiedName ofOuterClass(ASTUserClassOrInterface<?> astUserClass) {
        String[] classes = new String[]{astUserClass.getSimpleName()};
        return new ApexQualifiedName(classes, null);
    }

    static ApexQualifiedName ofNestedClass(ApexQualifiedName parent, ASTUserClassOrInterface<?> astUserClass) {
        String[] classes = Arrays.copyOf(parent.classes, parent.classes.length + 1);
        classes[classes.length - 1] = astUserClass.getSimpleName();
        return new ApexQualifiedName(classes, null);
    }

    static ApexQualifiedName ofOuterEnum(ASTUserEnum astUserEnum) {
        String[] classes = new String[]{astUserEnum.getSimpleName()};
        return new ApexQualifiedName(classes, null);
    }

    static ApexQualifiedName ofNestedEnum(ApexQualifiedName parent, ASTUserEnum astUserEnum) {
        String[] classes = Arrays.copyOf(parent.classes, parent.classes.length + 1);
        classes[classes.length - 1] = astUserEnum.getSimpleName();
        return new ApexQualifiedName(classes, null);
    }

    private static String getOperationString(ASTMethod node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getImage()).append('(');
        List paramTypes = node.children(ASTParameter.class).toStream().map(ASTParameter::getType).collect(Collectors.toList());
        if (!paramTypes.isEmpty()) {
            for (int i = 0; i < paramTypes.size(); ++i) {
                sb.append(i > 0 ? ", " : "");
                sb.append((String)paramTypes.get(i));
            }
        }
        sb.append(')');
        return sb.toString();
    }

    static ApexQualifiedName ofMethod(ASTMethod node) {
        ASTUserEnum enumParent = (ASTUserEnum)node.ancestors(ASTUserEnum.class).first();
        if (enumParent != null) {
            ApexQualifiedName baseName = enumParent.getQualifiedName();
            return new ApexQualifiedName(baseName.classes, ApexQualifiedName.getOperationString(node));
        }
        ASTUserClassOrInterface parent = (ASTUserClassOrInterface)node.ancestors(ASTUserClassOrInterface.class).firstOrThrow();
        if (parent instanceof ASTUserTrigger) {
            ASTUserTrigger trigger = (ASTUserTrigger)parent;
            String targetObj = trigger.getTargetName();
            return new ApexQualifiedName(new String[]{"trigger", targetObj}, trigger.getSimpleName());
        }
        ApexQualifiedName baseName = parent.getQualifiedName();
        return new ApexQualifiedName(baseName.classes, ApexQualifiedName.getOperationString(node));
    }
}

