/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.common.collect.ImmutableMap;
import com.google.summit.ast.modifier.AnnotationModifier;
import com.google.summit.ast.modifier.KeywordModifier;
import com.google.summit.ast.modifier.Modifier;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.AccessNode;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;

public final class ASTModifierNode
extends AbstractApexNode.Many<Modifier>
implements AccessNode {
    private static final Map<KeywordModifier.Keyword, Integer> OPCODES = ImmutableMap.builder().put((Object)KeywordModifier.Keyword.PUBLIC, (Object)1).put((Object)KeywordModifier.Keyword.PRIVATE, (Object)2).put((Object)KeywordModifier.Keyword.PROTECTED, (Object)4).put((Object)KeywordModifier.Keyword.ABSTRACT, (Object)1024).put((Object)KeywordModifier.Keyword.STATIC, (Object)8).put((Object)KeywordModifier.Keyword.FINAL, (Object)16).put((Object)KeywordModifier.Keyword.TRANSIENT, (Object)128).build();

    ASTModifierNode(List<Modifier> modifierNode) {
        super(modifierNode);
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    @Override
    public int getModifiers() {
        int modifiers = this.nodes.stream().filter(mod -> mod instanceof KeywordModifier).map(mod -> (KeywordModifier)mod).filter(mod -> OPCODES.containsKey(mod.getKeyword())).mapToInt(mod -> OPCODES.get(mod.getKeyword())).reduce(0, (current, bit) -> current | bit);
        ApexNode classOrInterface = (ApexNode)this.ancestors().get(1);
        if (this.nodes.isEmpty() && classOrInterface instanceof ASTUserInterface) {
            modifiers |= 0x401;
        }
        if ((modifiers & 1) > 0) {
            modifiers &= 0xFFFFFFFB;
            modifiers &= 0xFFFFFFFD;
        } else if ((modifiers & 4) > 0) {
            modifiers &= 0xFFFFFFFD;
        }
        return modifiers;
    }

    @Override
    public boolean isPublic() {
        return (this.getModifiers() & 1) == 1;
    }

    @Override
    public boolean isProtected() {
        return (this.getModifiers() & 4) == 4;
    }

    @Override
    public boolean isPrivate() {
        return (this.getModifiers() & 2) == 2;
    }

    @Override
    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) == 1024;
    }

    @Override
    public boolean isStatic() {
        return (this.getModifiers() & 8) == 8;
    }

    @Override
    public boolean isFinal() {
        return (this.getModifiers() & 0x10) == 16;
    }

    @Override
    public boolean isTransient() {
        return (this.getModifiers() & 0x80) == 128;
    }

    private boolean hasKeyword(KeywordModifier.Keyword keyword) {
        return this.nodes.stream().filter(mod -> mod instanceof KeywordModifier).map(mod -> (KeywordModifier)mod).anyMatch(mod -> mod.getKeyword() == keyword);
    }

    private boolean hasAnnotation(String name) {
        return this.nodes.stream().filter(mod -> mod instanceof AnnotationModifier).map(mod -> (AnnotationModifier)mod).anyMatch(mod -> mod.getName().getString().equalsIgnoreCase(name));
    }

    public boolean isTest() {
        return this.hasAnnotation("isTest") || this.hasKeyword(KeywordModifier.Keyword.TESTMETHOD);
    }

    public boolean hasDeprecatedTestMethod() {
        return this.hasKeyword(KeywordModifier.Keyword.TESTMETHOD);
    }

    public boolean isTestOrTestSetup() {
        return this.isTest() || this.hasAnnotation("testSetup");
    }

    public boolean isWithSharing() {
        return this.hasKeyword(KeywordModifier.Keyword.WITHSHARING);
    }

    public boolean isWithoutSharing() {
        return this.hasKeyword(KeywordModifier.Keyword.WITHOUTSHARING);
    }

    public boolean isInheritedSharing() {
        return this.hasKeyword(KeywordModifier.Keyword.INHERITEDSHARING);
    }

    public boolean isWebService() {
        return this.hasKeyword(KeywordModifier.Keyword.WEBSERVICE);
    }

    public boolean isGlobal() {
        return this.hasKeyword(KeywordModifier.Keyword.GLOBAL);
    }

    public boolean isOverride() {
        return this.hasKeyword(KeywordModifier.Keyword.OVERRIDE);
    }

    public boolean isVirtual() {
        return this.hasKeyword(KeywordModifier.Keyword.VIRTUAL);
    }
}

