/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex;

import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.apex.ApexAnnotationSuppressor;
import net.sourceforge.pmd.lang.apex.ast.ApexParser;
import net.sourceforge.pmd.lang.apex.internal.ApexDesignerBindings;
import net.sourceforge.pmd.lang.apex.metrics.ApexMetrics;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.metrics.LanguageMetricsProvider;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.designerbindings.DesignerBindings;

class ApexLanguageHandler
implements LanguageVersionHandler {
    private final ApexMetricsProvider myMetricsProvider = new ApexMetricsProvider();

    ApexLanguageHandler() {
    }

    public Parser getParser() {
        return new ApexParser();
    }

    public List<ViolationSuppressor> getExtraViolationSuppressors() {
        return ApexAnnotationSuppressor.ALL_APEX_SUPPRESSORS;
    }

    public LanguageMetricsProvider getLanguageMetricsProvider() {
        return this.myMetricsProvider;
    }

    public DesignerBindings getDesignerBindings() {
        return ApexDesignerBindings.INSTANCE;
    }

    private static final class ApexMetricsProvider
    implements LanguageMetricsProvider {
        private final Set<Metric<?, ?>> metrics = CollectionUtil.setOf(ApexMetrics.COGNITIVE_COMPLEXITY, (Object[])new Metric[]{ApexMetrics.CYCLO, ApexMetrics.WEIGHED_METHOD_COUNT});

        private ApexMetricsProvider() {
        }

        public Set<Metric<?, ?>> getMetrics() {
            return this.metrics;
        }
    }
}

