/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.performance;

import net.sourceforge.pmd.lang.apex.ast.ASTDmlDeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlInsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlMergeStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUndeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpdateStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSoqlExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSoslExpression;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.apex.rule.performance.AbstractAvoidNodeInLoopsRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class OperationWithLimitsInLoopRule
extends AbstractAvoidNodeInLoopsRule {
    public OperationWithLimitsInLoopRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Performance"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 150);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
        this.addRuleChainVisit(ASTDmlDeleteStatement.class);
        this.addRuleChainVisit(ASTDmlInsertStatement.class);
        this.addRuleChainVisit(ASTDmlMergeStatement.class);
        this.addRuleChainVisit(ASTDmlUndeleteStatement.class);
        this.addRuleChainVisit(ASTDmlUpdateStatement.class);
        this.addRuleChainVisit(ASTDmlUpsertStatement.class);
        this.addRuleChainVisit(ASTMethodCallExpression.class);
        this.addRuleChainVisit(ASTSoqlExpression.class);
        this.addRuleChainVisit(ASTSoslExpression.class);
    }

    @Override
    public Object visit(ASTDmlDeleteStatement node, Object data) {
        return this.checkForViolation(node, data);
    }

    @Override
    public Object visit(ASTDmlInsertStatement node, Object data) {
        return this.checkForViolation(node, data);
    }

    @Override
    public Object visit(ASTDmlMergeStatement node, Object data) {
        return this.checkForViolation(node, data);
    }

    @Override
    public Object visit(ASTDmlUndeleteStatement node, Object data) {
        return this.checkForViolation(node, data);
    }

    @Override
    public Object visit(ASTDmlUpdateStatement node, Object data) {
        return this.checkForViolation(node, data);
    }

    @Override
    public Object visit(ASTDmlUpsertStatement node, Object data) {
        return this.checkForViolation(node, data);
    }

    @Override
    public Object visit(ASTMethodCallExpression node, Object data) {
        if (Helper.isAnyDatabaseMethodCall(node)) {
            return this.checkForViolation(node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTSoqlExpression node, Object data) {
        return this.checkForViolation(node, data);
    }

    @Override
    public Object visit(ASTSoslExpression node, Object data) {
        return this.checkForViolation(node, data);
    }
}

