/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class MethodWithSameNameAsEnclosingClassRule
extends AbstractApexRule {
    public MethodWithSameNameAsEnclosingClassRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Style"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 50);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
        this.addRuleChainVisit(ASTUserClass.class);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        String className = node.getImage();
        List methods = node.findDescendantsOfType(ASTMethod.class);
        for (ASTMethod m : methods) {
            String methodName = m.getImage();
            if (m.isConstructor() || !methodName.equalsIgnoreCase(className)) continue;
            this.addViolation(data, m);
        }
        return data;
    }
}

