/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.metrics.signature;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.metrics.signature.ApexSignature;
import net.sourceforge.pmd.lang.metrics.Signature;

public final class ApexOperationSignature
extends ApexSignature
implements Signature<ASTMethod> {
    private static final Map<Integer, ApexOperationSignature> POOL = new HashMap<Integer, ApexOperationSignature>();

    private ApexOperationSignature(ApexSignature.Visibility visibility) {
        super(visibility);
    }

    public int hashCode() {
        return ApexOperationSignature.code(this.visibility);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    private static int code(ApexSignature.Visibility visibility) {
        return visibility.hashCode();
    }

    public static ApexOperationSignature of(ASTMethod node) {
        ApexSignature.Visibility visibility = ApexSignature.Visibility.get(node);
        int code = ApexOperationSignature.code(visibility);
        if (!POOL.containsKey(code)) {
            POOL.put(code, new ApexOperationSignature(visibility));
        }
        return POOL.get(code);
    }
}

