/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.Identifier;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import java.lang.reflect.Field;
import java.util.Optional;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.apex.ast.ASTNewKeyValueObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexParserVisitor;

public class ASTLiteralExpression
extends AbstractApexNode<LiteralExpression> {
    @Deprecated
    @InternalApi
    public ASTLiteralExpression(LiteralExpression literalExpression) {
        super(literalExpression);
    }

    @Override
    public Object jjtAccept(ApexParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public LiteralType getLiteralType() {
        return ((LiteralExpression)this.node).getLiteralType();
    }

    public boolean isString() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.STRING;
    }

    public boolean isBoolean() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.TRUE || ((LiteralExpression)this.node).getLiteralType() == LiteralType.FALSE;
    }

    public boolean isInteger() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.INTEGER;
    }

    public boolean isDouble() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.DOUBLE;
    }

    public boolean isLong() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.LONG;
    }

    public boolean isDecimal() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.DECIMAL;
    }

    public boolean isNull() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.NULL;
    }

    public String getImage() {
        if (((LiteralExpression)this.node).getLiteral() != null) {
            return String.valueOf(((LiteralExpression)this.node).getLiteral());
        }
        return null;
    }

    public String getName() {
        if (this.getParent() instanceof ASTNewKeyValueObjectExpression) {
            ASTNewKeyValueObjectExpression parent = (ASTNewKeyValueObjectExpression)this.getParent();
            try {
                Field exprField = NewKeyValueObjectExpression.NameValueParameter.class.getDeclaredField("expression");
                exprField.setAccessible(true);
                Optional<NewKeyValueObjectExpression.NameValueParameter> parameter = ((NewKeyValueObjectExpression)parent.node).getParameters().stream().filter(p -> {
                    try {
                        return exprField.get(p) == this.node;
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        return false;
                    }
                }).findFirst();
                Field nameField = NewKeyValueObjectExpression.NameValueParameter.class.getDeclaredField("name");
                nameField.setAccessible(true);
                return parameter.map(p -> {
                    try {
                        return (Identifier)nameField.get(p);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        return null;
                    }
                }).map(Identifier::getValue).orElse(null);
            }
            catch (NoSuchFieldException | SecurityException e1) {
                return null;
            }
        }
        return null;
    }
}

