/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.BasicURLHandler;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;

public class HttpClientHandler
extends AbstractURLHandler {
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private int proxyPort;
    private String proxyHost = null;
    private String proxyUserName = null;
    private String proxyPasswd = null;
    private HttpClientHelper httpClientHelper;
    private static HttpClient httpClient;

    public HttpClientHandler() {
        this.configureProxy();
    }

    private void configureProxy() {
        this.proxyHost = System.getProperty("http.proxyHost");
        if (this.useProxy()) {
            this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            this.proxyUserName = System.getProperty("http.proxyUser");
            this.proxyPasswd = System.getProperty("http.proxyPassword");
            Message.verbose("proxy configured: host=" + this.proxyHost + " port=" + this.proxyPort + " user=" + this.proxyUserName);
        } else {
            Message.verbose("no proxy configured");
        }
    }

    public InputStream openStream(URL url) throws IOException {
        GetMethod get = this.doGet(url, 0);
        if (!this.checkStatusCode(url, get)) {
            get.releaseConnection();
            throw new IOException("The HTTP response code for " + url + " did not indicate a success." + " See log for more detail.");
        }
        Header encoding = get.getResponseHeader("Content-Encoding");
        return this.getDecodingInputStream(encoding == null ? null : encoding.getValue(), get.getResponseBodyAsStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        GetMethod get = this.doGet(src, 0);
        try {
            if (!this.checkStatusCode(src, get)) {
                throw new IOException("The HTTP response code for " + src + " did not indicate a success." + " See log for more detail.");
            }
            Header encoding = get.getResponseHeader("Content-Encoding");
            InputStream is = this.getDecodingInputStream(encoding == null ? null : encoding.getValue(), get.getResponseBodyAsStream());
            FileUtil.copy(is, dest, l);
            dest.setLastModified(this.getLastModified(get));
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(File src, URL dest, CopyProgressListener l) throws IOException {
        HttpClient client = this.getClient();
        PutMethod put = new PutMethod(this.normalizeToString(dest));
        put.setDoAuthentication(this.useAuthentication(dest) || this.useProxyAuthentication());
        try {
            put.setRequestEntity(new FileRequestEntity(src));
            int statusCode = client.executeMethod(put);
            this.validatePutStatusCode(dest, statusCode, null);
        }
        finally {
            put.releaseConnection();
        }
    }

    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        HttpMethodBase method = null;
        try {
            method = this.getRequestMethod() == 2 ? this.doHead(url, timeout) : this.doGet(url, timeout);
            if (this.checkStatusCode(url, method)) {
                String contentType = method.getResponseHeader("content-type").getValue();
                String bodyCharset = BasicURLHandler.getCharSetFromContentType(contentType);
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, this.getResponseContentLength(method), this.getLastModified(method), bodyCharset);
                return uRLInfo;
            }
        }
        catch (HttpException e) {
            Message.error("HttpClientHandler: " + e.getMessage() + ":" + e.getReasonCode() + "=" + e.getReason() + " url=" + url);
        }
        catch (UnknownHostException e) {
            Message.warn("Host " + e.getMessage() + " not found. url=" + url);
            Message.info("You probably access the destination server through a proxy server that is not well configured.");
        }
        catch (IOException e) {
            Message.error("HttpClientHandler: " + e.getMessage() + " url=" + url);
        }
        catch (IllegalArgumentException e) {
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return UNAVAILABLE;
    }

    private boolean checkStatusCode(URL url, HttpMethodBase method) throws IOException {
        int status = method.getStatusCode();
        if (status == 200) {
            return true;
        }
        if ("HEAD".equals(method.getName()) && status == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + status + " url=" + url);
        if (status == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(status).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + method.getStatusText() + " url=" + url);
        } else if (String.valueOf(status).startsWith("5")) {
            Message.error("SERVER ERROR: " + method.getStatusText() + " url=" + url);
        }
        return false;
    }

    private long getLastModified(HttpMethodBase method) {
        Header header = method.getResponseHeader("last-modified");
        if (header != null) {
            String lastModified = header.getValue();
            try {
                return LAST_MODIFIED_FORMAT.parse(lastModified).getTime();
            }
            catch (ParseException e) {
                return System.currentTimeMillis();
            }
        }
        return System.currentTimeMillis();
    }

    private long getResponseContentLength(HttpMethodBase head) {
        return this.getHttpClientHelper().getResponseContentLength(head);
    }

    private HttpClientHelper getHttpClientHelper() {
        if (this.httpClientHelper == null) {
            try {
                HttpMethodBase.class.getMethod("getResponseContentLength", new Class[0]);
                this.httpClientHelper = new HttpClientHelper3x();
                Message.verbose("using commons httpclient 3.x helper");
            }
            catch (SecurityException e) {
                Message.verbose("unable to get access to getResponseContentLength of commons-httpclient HeadMethod. Please use commons-httpclient 3.0 or use ivy with sufficient security permissions.");
                Message.verbose("exception: " + e.getMessage());
                this.httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
            catch (NoSuchMethodException e) {
                this.httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
        }
        return this.httpClientHelper;
    }

    public int getHttpClientMajorVersion() {
        HttpClientHelper helper = this.getHttpClientHelper();
        return helper.getHttpClientMajorVersion();
    }

    private GetMethod doGet(URL url, int timeout) throws IOException {
        HttpClient client = this.getClient();
        client.setTimeout(timeout);
        GetMethod get = new GetMethod(this.normalizeToString(url));
        get.setDoAuthentication(this.useAuthentication(url) || this.useProxyAuthentication());
        get.setRequestHeader("Accept-Encoding", "gzip,deflate");
        client.executeMethod(get);
        return get;
    }

    private HeadMethod doHead(URL url, int timeout) throws IOException {
        HttpClient client = this.getClient();
        client.setTimeout(timeout);
        HeadMethod head = new HeadMethod(this.normalizeToString(url));
        head.setDoAuthentication(this.useAuthentication(url) || this.useProxyAuthentication());
        client.executeMethod(head);
        return head;
    }

    private HttpClient getClient() {
        if (httpClient == null) {
            final MultiThreadedHttpConnectionManager connManager = new MultiThreadedHttpConnectionManager();
            httpClient = new HttpClient(connManager);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    connManager.shutdown();
                }
            }));
            ArrayList<String> authPrefs = new ArrayList<String>(3);
            authPrefs.add("Digest");
            authPrefs.add("Basic");
            authPrefs.add("NTLM");
            httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
            if (this.useProxy()) {
                httpClient.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
                if (this.useProxyAuthentication()) {
                    httpClient.getState().setProxyCredentials(new AuthScope(this.proxyHost, this.proxyPort, AuthScope.ANY_REALM), HttpClientHandler.createCredentials(this.proxyUserName, this.proxyPasswd));
                }
            }
            httpClient.getParams().setParameter("http.useragent", (Object)("Apache Ivy/" + Ivy.getIvyVersion()));
            httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)new IvyCredentialsProvider());
        }
        return httpClient;
    }

    private boolean useProxy() {
        return this.proxyHost != null && this.proxyHost.trim().length() > 0;
    }

    private boolean useAuthentication(URL url) {
        return CredentialsStore.INSTANCE.hasCredentials(url.getHost());
    }

    private boolean useProxyAuthentication() {
        return this.proxyUserName != null && this.proxyUserName.trim().length() > 0;
    }

    private static org.apache.commons.httpclient.Credentials createCredentials(String username, String password) {
        String domain;
        String user;
        int backslashIndex = username.indexOf(92);
        if (backslashIndex >= 0) {
            user = username.substring(backslashIndex + 1);
            domain = username.substring(0, backslashIndex);
        } else {
            user = username;
            domain = System.getProperty("http.auth.ntlm.domain", "");
        }
        return new NTCredentials(user, password, HostUtil.getLocalHostName(), domain);
    }

    private static class FileRequestEntity
    implements RequestEntity {
        private File file;

        public FileRequestEntity(File file) {
            this.file = file;
        }

        public long getContentLength() {
            return this.file.length();
        }

        public String getContentType() {
            return null;
        }

        public boolean isRepeatable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRequest(OutputStream out) throws IOException {
            FileInputStream instream = new FileInputStream(this.file);
            try {
                FileUtil.copy(instream, out, null, false);
            }
            finally {
                ((InputStream)instream).close();
            }
        }
    }

    private static class IvyCredentialsProvider
    implements CredentialsProvider {
        private IvyCredentialsProvider() {
        }

        public org.apache.commons.httpclient.Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            String realm = scheme.getRealm();
            Credentials c = CredentialsStore.INSTANCE.getCredentials(realm, host);
            if (c != null) {
                return HttpClientHandler.createCredentials(c.getUserName(), c.getPasswd());
            }
            return null;
        }
    }

    public static interface HttpClientHelper {
        public long getResponseContentLength(HttpMethodBase var1);

        public int getHttpClientMajorVersion();
    }

    private static final class HttpClientHelper2x
    implements HttpClientHelper {
        private static final int VERSION = 2;

        private HttpClientHelper2x() {
        }

        public long getResponseContentLength(HttpMethodBase method) {
            Header header = method.getResponseHeader("Content-Length");
            if (header != null) {
                try {
                    return Integer.parseInt(header.getValue());
                }
                catch (NumberFormatException e) {
                    Message.verbose("Invalid content-length value: " + e.getMessage());
                }
            }
            return 0L;
        }

        public int getHttpClientMajorVersion() {
            return 2;
        }
    }

    private static final class HttpClientHelper3x
    implements HttpClientHelper {
        private static final int VERSION = 3;

        private HttpClientHelper3x() {
        }

        public long getResponseContentLength(HttpMethodBase method) {
            return method.getResponseContentLength();
        }

        public int getHttpClientMajorVersion() {
            return 3;
        }
    }
}

