/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.filter;

import com.tinkerpop.blueprints.Contains;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.filter.FilterPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.structures.AsMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class CollectionFilterPipe<S>
extends AbstractPipe<S, S>
implements FilterPipe<S> {
    private final Collection<S> storedCollection;
    private final Contains contains;

    public CollectionFilterPipe(Collection<S> storedCollection, Contains contains) {
        this.storedCollection = storedCollection;
        this.contains = contains;
    }

    public CollectionFilterPipe(Contains contains, AsMap asMap, String ... namedSteps) {
        this.storedCollection = new DynamicList(asMap, namedSteps);
        this.contains = contains;
    }

    @Override
    protected S processNextStart() {
        Object s;
        while (!this.contains.evaluate(s = this.starts.next(), this.storedCollection)) {
        }
        return (S)s;
    }

    @Override
    public String toString() {
        if (this.storedCollection instanceof DynamicList) {
            return PipeHelper.makePipeString(this, this.contains, ((DynamicList)this.storedCollection).toString());
        }
        return PipeHelper.makePipeString(this, this.contains);
    }

    private class DynamicList<S>
    extends ArrayList<S> {
        private final AsMap asMap;
        private final String[] namedSteps;

        public DynamicList(AsMap asMap, String ... namedSteps) {
            this.asMap = asMap;
            this.namedSteps = namedSteps;
        }

        @Override
        public boolean contains(Object object) {
            for (String namedStep : this.namedSteps) {
                if (!(null == object ? object == this.asMap.get(namedStep) : object.equals(this.asMap.get(namedStep)))) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return Arrays.asList(this.namedSteps).toString();
        }
    }
}

