/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.LexicographicalElementComparator;
import com.tinkerpop.blueprints.util.io.graphson.ElementPropertyConfig;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class GraphSONWriter {
    private static final JsonFactory jsonFactory = new MappingJsonFactory();
    private final Graph graph;

    public GraphSONWriter(Graph graph) {
        this.graph = graph;
    }

    public void outputGraph(String filename, Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, GraphSONMode mode) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        this.outputGraph(fos, vertexPropertyKeys, edgePropertyKeys, mode);
        fos.close();
    }

    public void outputGraph(OutputStream jsonOutputStream, Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, GraphSONMode mode) throws IOException {
        this.outputGraph(jsonOutputStream, vertexPropertyKeys, edgePropertyKeys, mode, false);
    }

    public void outputGraph(OutputStream jsonOutputStream, Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, GraphSONMode mode, boolean normalize) throws IOException {
        JsonGenerator jg = jsonFactory.createGenerator(jsonOutputStream);
        jg.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        GraphSONUtility graphson = new GraphSONUtility(mode, null, ElementPropertyConfig.includeProperties(vertexPropertyKeys, edgePropertyKeys, normalize));
        jg.writeStartObject();
        jg.writeStringField("mode", mode.toString());
        jg.writeArrayFieldStart("vertices");
        Iterable<Vertex> vertices = this.vertices(normalize);
        for (Vertex v : vertices) {
            jg.writeTree(graphson.objectNodeFromElement(v));
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("edges");
        Iterable<Edge> edges = this.edges(normalize);
        for (Edge e : edges) {
            jg.writeTree(graphson.objectNodeFromElement(e));
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
        jg.close();
    }

    private Iterable<Vertex> vertices(boolean normalize) {
        ArrayList<Vertex> vertices;
        if (normalize) {
            vertices = new ArrayList();
            for (Vertex v : this.graph.getVertices()) {
                ((Collection)vertices).add(v);
            }
            Collections.sort((List)vertices, new LexicographicalElementComparator());
        } else {
            vertices = this.graph.getVertices();
        }
        return vertices;
    }

    private Iterable<Edge> edges(boolean normalize) {
        ArrayList<Edge> edges;
        if (normalize) {
            edges = new ArrayList();
            for (Edge v : this.graph.getEdges()) {
                ((Collection)edges).add(v);
            }
            Collections.sort((List)edges, new LexicographicalElementComparator());
        } else {
            edges = this.graph.getEdges();
        }
        return edges;
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, null, null, GraphSONMode.NORMAL);
    }

    public static void outputGraph(Graph graph, String filename) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(filename, null, null, GraphSONMode.NORMAL);
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream, GraphSONMode mode) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, null, null, mode);
    }

    public static void outputGraph(Graph graph, String filename, GraphSONMode mode) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(filename, null, null, mode);
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream, Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, GraphSONMode mode) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, vertexPropertyKeys, edgePropertyKeys, mode);
    }

    public static void outputGraph(Graph graph, String filename, Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, GraphSONMode mode) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(filename, vertexPropertyKeys, edgePropertyKeys, mode);
    }
}

