/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.impls.tg.TinkerIndex;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class TinkerMetadataWriter {
    private final TinkerGraph graph;

    public TinkerMetadataWriter(TinkerGraph graph) {
        this.graph = graph;
    }

    public void save(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        this.save(fos);
        fos.close();
    }

    public void save(OutputStream outputStream) throws IOException {
        DataOutputStream writer = null;
        try {
            writer = new DataOutputStream(outputStream);
            writer.writeLong(this.graph.currentId);
            this.writeIndices(writer, this.graph);
            this.writeVertexKeyIndices(writer, this.graph);
            this.writeEdgeKeyIndices(writer, this.graph);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write metadata file");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write metadata file");
            }
        }
    }

    public static void save(TinkerGraph graph, OutputStream outputStream) throws IOException {
        TinkerMetadataWriter writer = new TinkerMetadataWriter(graph);
        writer.save(outputStream);
    }

    public static void save(TinkerGraph graph, String filename) throws IOException {
        TinkerMetadataWriter writer = new TinkerMetadataWriter(graph);
        writer.save(filename);
    }

    private void writeIndices(DataOutputStream writer, TinkerGraph graph) throws IOException {
        writer.writeInt(graph.indices.size());
        for (Map.Entry<String, TinkerIndex> index : graph.indices.entrySet()) {
            writer.writeUTF(index.getKey());
            TinkerIndex tinkerIndex = index.getValue();
            Class indexClass = tinkerIndex.indexClass;
            writer.writeByte(indexClass.equals(Vertex.class) ? 1 : 2);
            writer.writeInt(tinkerIndex.index.size());
            Iterator i$ = tinkerIndex.index.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry tinkerIndexItem = o = i$.next();
                writer.writeUTF(tinkerIndexItem.getKey());
                Map tinkerIndexItemSet = tinkerIndexItem.getValue();
                writer.writeInt(tinkerIndexItemSet.size());
                Iterator i$2 = tinkerIndexItemSet.entrySet().iterator();
                while (i$2.hasNext()) {
                    Map.Entry p;
                    Map.Entry items = p = i$2.next();
                    if (indexClass.equals(Vertex.class)) {
                        Set vertices = items.getValue();
                        writer.writeInt(vertices.size());
                        for (Vertex v : vertices) {
                            this.writeTypedData(writer, v.getId());
                        }
                        continue;
                    }
                    if (!indexClass.equals(Edge.class)) continue;
                    Set edges = items.getValue();
                    writer.writeInt(edges.size());
                    for (Edge e : edges) {
                        this.writeTypedData(writer, e.getId());
                    }
                }
            }
        }
    }

    private void writeVertexKeyIndices(DataOutputStream writer, TinkerGraph graph) throws IOException {
        writer.writeInt(graph.vertexKeyIndex.index.size());
        for (Map.Entry index : graph.vertexKeyIndex.index.entrySet()) {
            writer.writeUTF((String)index.getKey());
            writer.writeInt(((Map)index.getValue()).size());
            for (Map.Entry item : ((Map)index.getValue()).entrySet()) {
                this.writeTypedData(writer, item.getKey());
                writer.writeInt(((Set)item.getValue()).size());
                for (Vertex v : (Set)item.getValue()) {
                    this.writeTypedData(writer, v.getId());
                }
            }
        }
    }

    private void writeEdgeKeyIndices(DataOutputStream writer, TinkerGraph graph) throws IOException {
        writer.writeInt(graph.edgeKeyIndex.index.size());
        for (Map.Entry index : graph.edgeKeyIndex.index.entrySet()) {
            writer.writeUTF((String)index.getKey());
            writer.writeInt(((Map)index.getValue()).size());
            for (Map.Entry item : ((Map)index.getValue()).entrySet()) {
                this.writeTypedData(writer, item.getKey());
                writer.writeInt(((Set)item.getValue()).size());
                for (Edge e : (Set)item.getValue()) {
                    this.writeTypedData(writer, e.getId());
                }
            }
        }
    }

    private void writeTypedData(DataOutputStream writer, Object data) throws IOException {
        if (data instanceof String) {
            writer.writeByte(1);
            writer.writeUTF((String)data);
        } else if (data instanceof Integer) {
            writer.writeByte(2);
            writer.writeInt((Integer)data);
        } else if (data instanceof Long) {
            writer.writeByte(3);
            writer.writeLong((Long)data);
        } else if (data instanceof Short) {
            writer.writeByte(4);
            writer.writeShort(((Short)data).shortValue());
        } else if (data instanceof Float) {
            writer.writeByte(5);
            writer.writeFloat(((Float)data).floatValue());
        } else if (data instanceof Double) {
            writer.writeByte(6);
            writer.writeDouble((Double)data);
        } else {
            throw new IOException("unknown data type: use java serialization");
        }
    }
}

